package cn.com.duiba.developer.center.biz.dao.schedule;

import cn.com.duiba.developer.center.api.domain.dto.AppPushTaskDto;
import cn.com.duiba.developer.center.biz.entity.DuibaTaskEntity;

import java.util.Date;
import java.util.List;

/**
 * @Author【yaocheng@duiba.com.cn】
 * @Date 2016/11/8 21:19
 */
public interface DuibaTaskDao {

    /**
     * 通过id查询兑吧计划任务
     * @param duibaTaskId
     * @return
     */
    DuibaTaskEntity selectDuibaTaskById(Long duibaTaskId);

    /**
     * 新建兑吧计划任务
     * @param duibaTaskEntity
     * @return Long 兑吧计划任务表主键
     */
    Long insert(DuibaTaskEntity duibaTaskEntity);

    /**
     * 更新兑吧计划任务
     * @param duibaTaskEntity
     */
    void update(DuibaTaskEntity duibaTaskEntity);

    /**
     * 更新推送时间
     * @param id
     */
    void updatePushTimeById(Long id, Date date);

    /**
     * 删除兑吧计划任务
     * @param duibaTaskId
     * @param deleted
     */
    void delete(Long duibaTaskId,int deleted);
    
    /**
     * 计划任务列表查询
     * @param pageIndex
     * @param pageSize
     * @param duibaTaskEntity
     * @return
     */
    List<DuibaTaskEntity> selectScheduledTaskList(int pageIndex, int pageSize,DuibaTaskEntity duibaTaskEntity);
    /**
     * 计划任务列表count
     * @param duibaTaskEntity
     * @return
     */
    Integer selectScheduledTaskListCount(DuibaTaskEntity duibaTaskEntity);
    /**
     * 更新状态
     * @param duibaTaskId
     * @param status 任务状态，OPEN-开启；CLOSED-关闭
     */
	void updateStatus(Long duibaTaskId, String status);
    
}
