package cn.com.duiba.developer.center.biz.dao.schedule.impl;

import cn.com.duiba.developer.center.biz.dao.schedule.AppPushTaskDao;
import cn.com.duiba.developer.center.biz.entity.AppPushTaskEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;

import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author【yaocheng@duiba.com.cn】
 * @Date 2016/11/8 10:53
 */
@Repository
public class AppPushTaskDaoImpl extends BaseDao implements AppPushTaskDao {

    @Override
    public List<AppPushTaskEntity> queryAppPushTaskByDuibaId(Long duibaTaskId) {
        return selectList("queryAppPushTaskByDuibaId", duibaTaskId);
    }

    @Override
    public void insert(AppPushTaskEntity appPushTaskEntitys) {
        insert("insert", appPushTaskEntitys);
    }

    @Override
    public void update(AppPushTaskEntity appPushTaskEntity) {
        insert("update", appPushTaskEntity);
    }

    @Override
    public void deleteByDuibaTaskId(Long duibaTaskId) {
        delete("deleteByDuibaTaskId", duibaTaskId);
    }

    @Override
    public void updatePushTimeByDuibaTaskId(Long duibaTaskId, Date date) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("duibaTaskId", duibaTaskId);
        map.put("date", date);
        update("updatePushTimeByDuibaTaskId", map);
    }

    @Override
    public void delete(Long duibaTaskId, int deleted) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("duibaTaskId", duibaTaskId);
        map.put("deleted", deleted);
        update("delete", map);
    }

    @Override
    public List<AppPushTaskEntity> selectScheduledTaskAppList(int pageIndex, int pageSize) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("pageIndex", pageIndex);
        map.put("pageSize", pageSize);
        return selectList("selectScheduledTaskAppList", map);
    }

    @Override
    public Integer selectScheduledTaskAppCount() {
        return selectOne("selectScheduledTaskAppCount");
    }

    @Override
    public List<AppPushTaskEntity> selectAppPushTaskToExec(int queryTaskLimit) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("limit", queryTaskLimit);
        return selectList("selectAppPushTaskToExec", map);
    }

    @Override
    public void updateAppPushTaskStatus(long appPushTaskId, String status) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("appPushTaskId", appPushTaskId);
        map.put("status", status);
        update("updateAppPushTaskStatus", map);
    }

    @Override
    public void updateAppPushTaskTime(long appPushTaskId, Date pushTime) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("appPushTaskId", appPushTaskId);
        map.put("pushTime", pushTime);
        update("updateAppPushTaskTime", map);
    }

    @Override
    public AppPushTaskEntity selectById(long id) {
        return selectOne("selectById", id);
    }

    @Override
    public void updateExtParamById(long appPushTaskId, String extParam) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("appPushTaskId", appPushTaskId);
        map.put("extParam", extParam);
        update("updateExtParamById", map);
    }

    @Override
    public void updateFilterStatus(Long duibaTaskId, String status) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("duibaTaskId", duibaTaskId);
        map.put("status", status);
        update("updateFilterStatus", map);
    }

	@Override
	public Map<Long,Map<String,String>> selectBatchScheduledTaskAppNums(List<Long> pushTaskIds) {
		return selectMap("selectBatchScheduledTaskAppNums", pushTaskIds,"duibaTaskId");
	}
}
