package cn.com.duiba.developer.center.biz.dao.schedule.impl;

import cn.com.duiba.developer.center.biz.dao.schedule.DuibaTaskDao;
import cn.com.duiba.developer.center.biz.entity.DuibaTaskEntity;
import cn.com.duiba.developer.center.common.dao.BaseDao;

import com.google.common.collect.Maps;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author【yaocheng@duiba.com.cn】
 * @Date 2016/11/8 21:20
 */
@Repository
public class DuibaTaskDaoImpl extends BaseDao implements DuibaTaskDao {

    @Override
    public Long insert(DuibaTaskEntity duibaTaskEntity) {
        insert("insert",duibaTaskEntity);
        return duibaTaskEntity.getId();
    }

    @Override
    public void update(DuibaTaskEntity duibaTaskEntity) {
        update("update",duibaTaskEntity);
    }

    @Override
    public void updatePushTimeById(Long id, Date date) {
        Map<String,Object> map= Maps.newHashMap();
        map.put("id",id);
        map.put("date",date);
        update("updatePushTimeById",map);
    }

    @Override
    public DuibaTaskEntity selectDuibaTaskById(Long duibaTaskId) {
        return selectOne("selectDuibaTaskById",duibaTaskId);
    }

    @Override
    public void delete(Long duibaTaskId,int deleted) {
        Map<String,Object> map= Maps.newHashMap();
        map.put("duibaTaskId",duibaTaskId);
        map.put("deleted",deleted);
        update("delete",map);
    }

	@Override
	public List<DuibaTaskEntity> selectScheduledTaskList(int pageIndex,int pageSize, DuibaTaskEntity duibaTaskEntity) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("pageIndex", pageIndex);
		map.put("pageSize", pageSize);
		map.put("duibaTaskEntity", duibaTaskEntity);
		List<DuibaTaskEntity> l  = selectList("selectScheduledTaskList", map);
		return l;
	}

	@Override
	public Integer selectScheduledTaskListCount(DuibaTaskEntity duibaTaskEntity) {
		return selectOne("selectScheduledTaskListCount",duibaTaskEntity);
	}

	@Override
	public void updateStatus(Long duibaTaskId, String status) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("duibaTaskId", duibaTaskId);
		map.put("status", status);
		update("updateStatus", map);
	}
}
