package cn.com.duiba.developer.center.biz.dao.statistics;

import cn.com.duiba.developer.center.biz.dataobject.statistics.OdpsAppItemDwmStatEntity;
import cn.com.duiba.developer.center.biz.dataobject.statistics.OdpsAppItemWeekMonthStatEntity;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface OdpsAppItemDwmStatDao {

	/**
	 * 根据appId和开始日期，结束日期，查询
	 */
	public List<OdpsAppItemDwmStatEntity> findSumByAppIdAndDayBetween(Long appId, Date startDay, Date endDay);

	/**
	 * 根据appId和开始日期，结束日期，查询周月
	 */
	public OdpsAppItemWeekMonthStatEntity findWeekAndMonthByAppIdAndDay(Long appId, Date startDay, Date endDay, Long relationId, Integer relationType);
	
	
	
	/**
	 * 根据appId和开始日期，结束日期
	 */
	public List<OdpsAppItemDwmStatEntity> findSumByAppIdAndDayAndOrderBy(Map<String, Object> params);
	
	/**
	 * 根据appId和开始日期，结束日期
	 */
	public List<OdpsAppItemDwmStatEntity> findSumByAppIdAndDayAndIdAndTypeAndOrderBy(Map<String, Object> params);
	
	
	public List<OdpsAppItemWeekMonthStatEntity> findWeekAndMonthByAppIdAndDay(Long appId, Date startDay, Date endDay, List<Long> relationIds, Integer relationType);
}
