package cn.com.duiba.developer.center.biz.dao.statistics.impl;

import cn.com.duiba.developer.center.biz.dao.statistics.OdpsAppLayoutStatDao;
import cn.com.duiba.developer.center.biz.dataobject.statistics.AppLayoutCountDo;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import cn.com.duiba.developer.center.common.dao.DatabaseSchema;
import com.google.common.collect.Maps;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 16/8/3.
 */
@Repository
public class OdpsAppLayoutStatDaoImpl extends BaseDao implements OdpsAppLayoutStatDao {

    public OdpsAppLayoutStatDaoImpl(){
        this.databaseSchema = DatabaseSchema.ODPS;
    }

    @Override
    public List<AppLayoutCountDo> getLayoutCount(List<Long> brickIds,String day) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("brickIds",brickIds);
        params.put("day",day);
        return selectList("getLayoutCount",params);
    }
}
