package cn.com.duiba.developer.center.biz.entity;

import cn.com.duiba.developer.center.api.domain.BaseDO;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppLayoutBrickDO;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.Date;

/**
 * Created by liuyao on 16/7/29.
 */
public class AppLayoutEntity extends BaseEntity {
    private static final long serialVersionUID = 1123L;
    private Long id;
    private Long appId;

    private String brickIds;
    private String draftBrickIds;//弃用字段 但数据库中不能为空,且无默认值,所以在insert必须手动赋值,后面弃用字段同理
    private String customBrickIds;//弃用字段

    private String themeColor;
    private Short skinType;
    private Long skinId;
    private String developSortJson;
    private String developDataShowJson;

    private Date gmtCreate;
    private Date gmtModified;

    public AppLayoutEntity() {
    }

    public AppLayoutEntity(boolean init4insert) {
        if (init4insert) {
            toBeInsert = true;
            draftBrickIds = "{}";
            customBrickIds = "{}";
            skinType = 0;
            gmtCreate = new Date();
            gmtModified = new Date();
        }

    }

    public Long getThemeId(){
        if(StringUtils.isBlank(brickIds)){
            return null;
        }
        JSONObject json = JSONObject.parseObject(brickIds);
        return json.getLong("0")==null?1L:json.getLong("0");

    }

    public AppLayoutEntity(Long id) {
        toBeUpdate = true;
        this.id = id;
        gmtModified = new Date();
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getBrickIds() {
        return brickIds;
    }

    public void setBrickIds(String brickIds) {
        this.brickIds = brickIds;
    }

    public String getThemeColor() {
        return themeColor;
    }

    public void setThemeColor(String themeColor) {
        this.themeColor = themeColor;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getDraftBrickIds() {
        return draftBrickIds;
    }

    public void setDraftBrickIds(String draftBrickIds) {
        this.draftBrickIds = draftBrickIds;
    }

    public String getCustomBrickIds() {
        return customBrickIds;
    }

    public void setCustomBrickIds(String customBrickIds) {
        this.customBrickIds = customBrickIds;
    }

    public Short getSkinType() {
        return skinType;
    }

    public void setSkinType(Short skinType) {
        this.skinType = skinType;
    }

    public Long getSkinId() {
        return skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }

    public String getDevelopSortJson() {
        return developSortJson;
    }

    public void setDevelopSortJson(String developSortJson) {
        this.developSortJson = developSortJson;
    }

    public String getDevelopDataShowJson() {
        return developDataShowJson;
    }

    public void setDevelopDataShowJson(String developDataShowJson) {
        this.developDataShowJson = developDataShowJson;
    }
}
