package cn.com.duiba.developer.center.biz.entity;

import java.util.Date;

import cn.com.duiba.developer.center.api.domain.BaseDO;

/**
 * Created by liuyao on 2016/10/8.
 */
public class DeveloperEntity extends BaseEntity {


    private Long id;
    private String email;
    private String password;
    private String name;
    private String company;
    private String phone;
    private Boolean verify;
    private Boolean enable;
    private Integer remindMoney;
    private Date lastRemindTime;
    private Integer developerSwitch;
    private String json;
    private Date gmtCreate;
    private Date gmtModified;

    public DeveloperEntity(Long id){
        this.id = id;
        this.gmtModified = new Date();
        toBeUpdate = true;
    }

    public DeveloperEntity(boolean init4insert) {
        if (init4insert) {
            toBeInsert = true;
            verify = false;
            enable = true;
            gmtCreate = new Date();
            gmtModified = gmtCreate;
            developerSwitch = 0;
        }
    }

    public DeveloperEntity(){}

    public void disableSwitch(Integer type) {
        int v=1<<type;
        v=~v;
        developerSwitch = developerSwitch & v;
    }

    public void enableSwitch(Integer type) {
        int v=1<<type;
        developerSwitch = developerSwitch | v;
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Boolean getVerify() {
        return verify;
    }

    public void setVerify(Boolean verify) {
        this.verify = verify;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Integer getRemindMoney() {
        return remindMoney;
    }

    public void setRemindMoney(Integer remindMoney) {
        this.remindMoney = remindMoney;
    }

    public Date getLastRemindTime() {
        return lastRemindTime;
    }

    public void setLastRemindTime(Date lastRemindTime) {
        this.lastRemindTime = lastRemindTime;
    }

    public Integer getDeveloperSwitch() {
        return developerSwitch;
    }

    public void setDeveloperSwitch(Integer developerSwitch) {
        this.developerSwitch = developerSwitch;
    }

    public String getJson() {
        return json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public int hashCode() {
        return id.hashCode() * 37 + email.hashCode() * 17;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DeveloperEntity) {
            DeveloperEntity developer = (DeveloperEntity) obj;
            return (developer.id.equals(id) && developer.email.equals(email));
        }
        return super.equals(obj);
    }
}
