package cn.com.duiba.developer.center.biz.entity;

import java.util.Date;

import cn.com.duiba.developer.center.api.domain.BaseDO;

/**
 * Created by zhengjy on 2016/09/05
 */
public class SupplierProductEntity extends BaseEntity {
	
	private Long id;
	private String supplier;
	private String productId;
	private String name;
	private String mobile ;//运营商
	private String province; //省份
	private Integer facePrice;
	private Integer actualPrice;
	private Integer supplierPrice ;//供应商提供给我们的价格
	private Boolean enable;
	private String gameId;
	private Boolean duibaSwitch ;
	private String extra ;//额外参数

	//此参数不保存到数据库，只是作为临时保存数据使用
	private Integer actualPrice4Order;
	
	
	private Date gmtCreate;
	private Date gmtModified;
	
	public SupplierProductEntity() {
	}

	public SupplierProductEntity(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public SupplierProductEntity(boolean init4insert) {
		if (init4insert) {
			enable = true;
			facePrice = 0;
			actualPrice = 0;
			duibaSwitch = false;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getSupplier() {
		return supplier;
	}

	public void setSupplier(String supplier) {
		this.supplier = supplier;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public Integer getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(Integer facePrice) {
		this.facePrice = facePrice;
	}

	public Integer getActualPrice() {
		return actualPrice;
	}

	public void setActualPrice(Integer actualPrice) {
		this.actualPrice = actualPrice;
	}

	public Integer getSupplierPrice() {
		return supplierPrice;
	}

	public void setSupplierPrice(Integer supplierPrice) {
		this.supplierPrice = supplierPrice;
	}

	public Boolean getEnable() {
		return enable;
	}

	public void setEnable(Boolean enable) {
		this.enable = enable;
	}

	public String getGameId() {
		return gameId;
	}

	public void setGameId(String gameId) {
		this.gameId = gameId;
	}

	public Boolean getDuibaSwitch() {
		return duibaSwitch;
	}

	public void setDuibaSwitch(Boolean duibaSwitch) {
		this.duibaSwitch = duibaSwitch;
	}

	public String getExtra() {
		return extra;
	}

	public void setExtra(String extra) {
		this.extra = extra;
	}

	public Integer getActualPrice4Order() {
		return actualPrice4Order;
	}

	public void setActualPrice4Order(Integer actualPrice4Order) {
		this.actualPrice4Order = actualPrice4Order;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

}
