package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppBulletinDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppBulletinService;
import cn.com.duiba.developer.center.biz.bo.AppBulletinBo;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by liuyao on 16/9/10.
 */
@Service
public class RemoteAppBulletinServiceImpl implements RemoteAppBulletinService {
    @Autowired
    private AppBulletinBo appBulletinBo;

    @Override
    public DubboResult<AppBulletinDto> findAppBulletinDtoByAppId(Long appId) {
        AppBulletinDto dto = appBulletinBo.getAppBulletin(appId);
        return DubboResult.successResult(dto);
    }

    @Override
    public DubboResult<String> findAppBulletinDetailByAppId(Long appId) {
        return DubboResult.successResult(appBulletinBo.getdetailText(appId));
    }
}
