package cn.com.duiba.developer.center.biz.remoteservice.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.AppPushTaskDto;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.schedule.RemoteAppPushTaskService;
import cn.com.duiba.developer.center.biz.service.schedule.AppPushTaskService;
import cn.com.duiba.developer.center.common.tools.AppLogUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @Author【yaocheng@duiba.com.cn】
 * @Date 2016/11/8 9:50
 */
@Service
public class RemoteAppPushTaskServiceImpl implements RemoteAppPushTaskService {

    private static Logger log = LoggerFactory.getLogger(RemoteAppBannerServiceNewImpl.class);
    @Autowired
    private AppPushTaskService appPushTaskService;

    @Override
    public DubboResult<List<AppPushTaskDto>> queryAppPushTaskToExec() {
        try {
            return DubboResult.successResult(appPushTaskService.queryAppPushTaskToExec());
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appPushTaskService.queryAppPushTaskToExec failed", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Void> updateAppPushTaskStatus(long appPushTaskId, String status) {
        try {
            appPushTaskService.updateAppPushTaskStatus(appPushTaskId, status);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appPushTaskService.updateAppPushTaskStatus failed", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Void> updateAppPushTaskTime(long appPushTaskId, Date pushTime) {
        try {
            appPushTaskService.updateAppPushTaskTime(appPushTaskId, pushTime);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appPushTaskService.updateAppPushTaskTime failed", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<Void> updateExtParamById(long appPushTaskId, String key, String value) {
        try {
            appPushTaskService.updateExtParamById(appPushTaskId, key, value);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appPushTaskService.updateExtParamById failed", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<AppPushTaskDto>> queryAppPushTaskForEdit(Long duibaTaskId) {
        try {
            return DubboResult.successResult(appPushTaskService.queryAppPushTaskForEdit(duibaTaskId));
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appPushTaskService.queryAppPushTaskForEdit failed,duibaTaskId={}",duibaTaskId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> create(List<AppPushTaskDto> appPushTasks) {
        try {
            if(appPushTasks.get(0).getDuibaTaskId()!=null)
                appPushTaskService.update(appPushTasks);
            else
                appPushTaskService.create(appPushTasks);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appPushTaskService.create failed,appPushTasks={}",appPushTasks, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> executeRightNow(Long duibaTaskId) {
        try {
            appPushTaskService.executeRightNow(duibaTaskId);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appPushTaskService.executeRightNow failed,duibaTaskId={}",duibaTaskId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> delete(Long duibaTaskId) {
        try {
            appPushTaskService.delete(duibaTaskId);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke appPushTaskService.delete failed,duibaTaskId={}", duibaTaskId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

	@Override
	public DubboResult<PaginationVO<AppPushTaskDto>> findScheduledTaskList(
			int pageIndex, int pageSize, AppPushTaskDto appPushTaskDto) {
		try {
			PaginationVO<AppPushTaskDto> page = new PaginationVO<AppPushTaskDto>();
			List<AppPushTaskDto> list = appPushTaskService.findScheduledTaskList(pageIndex, pageSize, appPushTaskDto);
			Integer count = appPushTaskService.findScheduledTaskListCount(appPushTaskDto);
			page.setRows(list);
			page.setTotalCount(Long.valueOf(count));
            return DubboResult.successResult(page);
        } catch (Exception e) {
            return DubboResult.failResult(e.getMessage());
        }
	}

	@Override
	public DubboResult<PaginationVO<AppPushTaskDto>> findScheduledTaskAppList(
			int pageIndex, int pageSize, Long pushTaskId) {
		try {
			PaginationVO<AppPushTaskDto> page = new PaginationVO<AppPushTaskDto>();
			List<AppPushTaskDto> list = appPushTaskService.findScheduledTaskAppList(pageIndex, pageSize);
			Integer count = appPushTaskService.findScheduledTaskAppCount();
			page.setRows(list);
			page.setTotalCount(Long.valueOf(count));
            return DubboResult.successResult(page);
        } catch (Exception e) {
            return DubboResult.failResult(e.getMessage());
        }
	}

	@Override
	public DubboResult<Void> openPushTask(Long duibaTaskId) {
		appPushTaskService.openPushTask(duibaTaskId);
		return null;
	}

	@Override
	public DubboResult<Void> closePushTask(Long duibaTaskId) {
		appPushTaskService.closePushTask(duibaTaskId);
		return null;
	}

	@Override
	public DubboResult<Map<Long,Integer>> findBatchScheduledTaskAppNums(	List<Long> pushTaskIds) {
		try {
            return DubboResult.successResult(appPushTaskService.findBatchScheduledTaskAppNums(pushTaskIds));
        } catch (Exception e) {
            return DubboResult.failResult(e.getMessage());
        }
	}
}
