package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.*;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.api.domain.paramquery.AppUrlParams;
import cn.com.duiba.developer.center.biz.bo.AerosolBo;
import cn.com.duiba.developer.center.biz.bo.AppManagerBo;
import cn.com.duiba.developer.center.biz.service.credits.AppBudgetService;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.developer.center.biz.bo.AppBo;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.stereotype.Service;

/**
 * Created by liuyao on 16/7/29.
 */
@Service
public class RemoteAppServiceImpl implements RemoteAppService {
    private static final Logger logger= LoggerFactory.getLogger(RemoteAppServiceImpl.class);
    @Autowired
    private AppBo appBo;
    @Autowired
    private AppBudgetService appBudgetService;
    @Autowired
    private AppManagerBo appManagerBo;

    @Override
    public DubboResult<Long> createApp(CreateAppQueryParams param) {

        try {
            ValidatorTool.valid(param);
            return DubboResult.successResult(appBo.createApp(param));
        }catch(BusinessException e){
            logger.info("App创建失败",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<AppSimpleDto> getSimpleApp(Long id) {
        return DubboResult.successResult(appBo.getSimpleApp(id));
    }

    @Override
    public DubboResult<AppBudgetDto> getAppBudget(Long id) {
        return DubboResult.successResult(appBudgetService.getObject(id));
    }

    @Override
    public DubboResult<Boolean> updateAppInfo(AppInfoFromParams params) {
        try{
            ValidatorTool.valid(params);
            appManagerBo.updateAppInfo(params);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            logger.info("更新App信息失败",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateApiConfig(AppUrlParams appUrlParams) {
        try{
            ValidatorTool.valid(appUrlParams);
            appManagerBo.updateApiConfig(appUrlParams);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            logger.info("更新App接口失败",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> updateBudgetConfig(AppBudgetDto appBudget) {
        try{
            ValidatorTool.valid(appBudget);
            appManagerBo.budgetConfig(appBudget);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            logger.info("更新App预算失败",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> doSendSecret(Long appId) {
        try{
            appManagerBo.doSendSecret(appId);
            return DubboResult.successResult(true);
        }catch(BusinessException e){
            logger.info("发送App秘钥失败",e);
            return DubboResult.failResult(e.getMessage());
        }

    }

}
