package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.DeveloperDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateDeveloperParams;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDeveloperService;
import cn.com.duiba.developer.center.biz.bo.DeveloperBo;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by liuyao on 2016/10/8.
 */
@Service
public class RemoteDeveloperServiceImpl implements RemoteDeveloperService {
    private static final Logger logger= LoggerFactory.getLogger(RemoteDeveloperServiceImpl.class);
    @Autowired
    private DeveloperBo developerBo;

    @Override
    public DubboResult<Long> createDeveloper(CreateDeveloperParams params, Boolean needVerify) {
        try{
            ValidatorTool.valid(params);
            return DubboResult.successResult(developerBo.createDeveloper(params,needVerify));
        }catch (BusinessException e){
            logger.info("创建开发者失败",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<DeveloperDto> findDeveloperByEmail(String email) {
        return DubboResult.successResult(developerBo.findDeveloperByEmail(email));
    }
}
