package cn.com.duiba.developer.center.biz.remoteservice.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.AmbExpressTemplateDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteExpressTemplateService;
import cn.com.duiba.developer.center.biz.entity.AmbExpressTemplateEntity;
import cn.com.duiba.developer.center.biz.service.credits.ExpressTemplateService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

@Service
public class RemoteExpressTemplateServiceImpl implements RemoteExpressTemplateService {
	@Autowired
	private ExpressTemplateService expressTemplateService;
	private static Logger log=LoggerFactory.getLogger(RemoteExpressTemplateServiceImpl.class);
	@Override
    public DubboResult<AmbExpressTemplateDto> find(Long id) {
		try{
			AmbExpressTemplateEntity ate = expressTemplateService.find(id);
			AmbExpressTemplateDto ad = new AmbExpressTemplateDto();
			ObjectUtil.convert(ate, ad);
            return DubboResult.successResult(ad);
        }catch(Exception e){
            log.error("find error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
	

    @Override
    public DubboResult<Boolean> insert(AmbExpressTemplateDto entity) {
    	try{
    		AmbExpressTemplateEntity ad = new AmbExpressTemplateEntity();
    		ObjectUtil.convert(entity, ad);
			expressTemplateService.insert(ad);
            return DubboResult.successResult(true);
        }catch(Exception e){
            log.error("insert error ",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> update(AmbExpressTemplateDto entity) {
    	try{
    		AmbExpressTemplateEntity ad = new AmbExpressTemplateEntity();
    		ObjectUtil.convert(entity, ad);
			expressTemplateService.update(ad);
            return DubboResult.successResult(1);
        }catch(Exception e){
            log.error("update error ",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<AmbExpressTemplateDto>> findPageList(Map<String, Object> params) {
    	try{
    		List<AmbExpressTemplateEntity> ate = expressTemplateService.findPageList(params);
    		List<AmbExpressTemplateDto> ad = new ArrayList<AmbExpressTemplateDto>();
			ObjectUtil.convertList(ate, ad, AmbExpressTemplateDto.class);
            return DubboResult.successResult(ad);
        }catch(Exception e){
            log.error("findPageList error ",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> findPageCount(Map<String, Object> params) {
    	try{
			Long l = expressTemplateService.findPageCount(params);
            return DubboResult.successResult(l);
        }catch(Exception e){
            log.error("findPageCount error ",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteTemplateById(Long id) {
    	try{
			expressTemplateService.deleteTemplateById(id);
            return DubboResult.successResult(true);
        }catch(Exception e){
            log.error("deleteTemplateById error ",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<AmbExpressTemplateDto>> findByAppIdAndType(Long appId, String type) {
    	try{
    		List<AmbExpressTemplateEntity> ate = expressTemplateService.findByAppIdAndType(appId,type);
    		List<AmbExpressTemplateDto> ad = new ArrayList<AmbExpressTemplateDto>();
			ObjectUtil.convertList(ate, ad, AmbExpressTemplateDto.class);
            return DubboResult.successResult(ad);
        }catch(Exception e){
            log.error("findByAppIdAndType error ",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<AmbExpressTemplateDto> findByAppIdAndName(Long appId, String name) {
    	try{
			AmbExpressTemplateEntity ate = expressTemplateService.findByAppIdAndName(appId,name);
			AmbExpressTemplateDto ad = new AmbExpressTemplateDto();
			ObjectUtil.convert(ate, ad);
            return DubboResult.successResult(ad);
        }catch(Exception e){
            log.error("findByAppIdAndName error ",e);
            return DubboResult.failResult(e.getMessage());
        }
        
    }
}
