package cn.com.duiba.developer.center.biz.remoteservice.impl;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.ItemActivityExtDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteItemActivityExtService;
import cn.com.duiba.developer.center.biz.service.manager.ItemActivityExtService;
import cn.com.duiba.wolf.dubbo.DubboResult;

@Service
public class RemoteItemActivityExtServiceImpl implements RemoteItemActivityExtService{
	@Autowired
	ItemActivityExtService itemActivityExtService;

	@Override
	public DubboResult<Void> add(ItemActivityExtDto iaeDto) {
		try{
			itemActivityExtService.add(iaeDto);
			return DubboResult.successResult(null);
		}catch(Exception e){
			return DubboResult.failResult(e.getMessage());
		}
	}


	@Override
	public DubboResult<Map<String,String>> getExtParam(Long sourceId, String sourceType) {
		try{
			return DubboResult.successResult(itemActivityExtService.get(sourceId, sourceType));
		}catch(Exception e){
			return DubboResult.failResult(e.getMessage());
		}
	}

}
