package cn.com.duiba.developer.center.biz.remoteservice.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.PhonebillListDto;
import cn.com.duiba.developer.center.api.remoteservice.RemotePhoneBillListsService;
import cn.com.duiba.developer.center.biz.entity.PhonebillListEntity;
import cn.com.duiba.developer.center.biz.service.credits.PhoneBillListsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

@Service
public class RemotePhoneBillListsServiceimpl implements RemotePhoneBillListsService {
	@Autowired
	private PhoneBillListsService phoneBillListsService;
	
	@Override
	public DubboResult<List<PhonebillListDto>> findByMobileAndFacePrice(
			String mobile, Integer facePrice) {
		List<PhonebillListDto> ls = new ArrayList<PhonebillListDto>();
		List<PhonebillListEntity> list = phoneBillListsService.findByMobileAndFacePrice(mobile, facePrice);
		ObjectUtil.convertList(list, ls, PhonebillListDto.class);
		return DubboResult.successResult(ls);
	}

	@Override
	public DubboResult<List<PhonebillListDto>> findAllInFacePrice(
			List<Integer> facePrices) {
		
		List<PhonebillListDto> ls = new ArrayList<PhonebillListDto>();
		List<PhonebillListEntity> list = phoneBillListsService.findAllInFacePrice(facePrices);
		ObjectUtil.convertList(list, ls, PhonebillListDto.class);
		return DubboResult.successResult(ls);
	}

	@Override
	public DubboResult<PhonebillListDto> findByFacePriceAndMobile(
			Integer price, String mobile) {
		PhonebillListDto ls = new PhonebillListDto();
		PhonebillListEntity p = phoneBillListsService.findByFacePriceAndMobile(price, mobile);
		ObjectUtil.convert(p, ls);
		return DubboResult.successResult(ls);
	}

	@Override
	public DubboResult<List<PhonebillListDto>> findAll() {
		List<PhonebillListDto> ls = new ArrayList<PhonebillListDto>();
		List<PhonebillListEntity> list = phoneBillListsService.findAll();
		ObjectUtil.convertList(list, ls, PhonebillListDto.class);
		return DubboResult.successResult(ls);
	}

	@Override
	public void delete(Long id) {
		phoneBillListsService.delete(id);
	}

	@Override
	public void insert(PhonebillListDto phonebillListDO) {
		PhonebillListEntity p = new PhonebillListEntity();
		ObjectUtil.convert(phonebillListDO, p);
		phoneBillListsService.insert(p);
		
	}

	@Override
	public void update(PhonebillListDto phonebillListDO) {
		PhonebillListEntity p = new PhonebillListEntity();
		ObjectUtil.convert(phonebillListDO, p);
		phoneBillListsService.update(p);
		
	}

	@Override
	public DubboResult<PhonebillListDto> find(Long id) {
		PhonebillListDto ls = new PhonebillListDto();
		PhonebillListEntity p = phoneBillListsService.find(id);
		ObjectUtil.convert(p, ls);
		return DubboResult.successResult(ls);
	}


}
