package cn.com.duiba.developer.center.biz.remoteservice.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.SupplierProductDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteSupplierProductsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import cn.com.duiba.developer.center.biz.entity.SupplierProductEntity;
import cn.com.duiba.developer.center.biz.service.credits.SupplierProductsService;

@Service
public class RemoteSupplierProductsServiceImpl implements RemoteSupplierProductsService {
	
	@Autowired
	private SupplierProductsService supplierProductsService;

	@Override
	public DubboResult<SupplierProductDto> findBySupplier(String supplier) {
		SupplierProductEntity s = supplierProductsService.findBySupplier(supplier);
		SupplierProductDto ret =  new SupplierProductDto();
		ObjectUtil.convert(s, ret);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<SupplierProductDto>> findAllBySupplier(
			String supplier) {
		List<SupplierProductDto> list = new ArrayList<SupplierProductDto>();
		List<SupplierProductEntity> l = supplierProductsService.findAllBySupplier(supplier);
		ObjectUtil.convertList(l, list, SupplierProductDto.class);
		return DubboResult.successResult(list);
	}

	@Override
	public DubboResult<SupplierProductDto> findBySupplierAndProductId(
			String supplier, String productId) {
		SupplierProductEntity s = supplierProductsService.findBySupplierAndProductId(supplier, productId);
		SupplierProductDto ret =  new SupplierProductDto();
		ObjectUtil.convert(s, ret);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<SupplierProductDto>> findBySupplierAndFacePrice(
			String supplier, Integer facePrice) {
		List<SupplierProductDto> list = new ArrayList<SupplierProductDto>();
		List<SupplierProductEntity> l = supplierProductsService.findBySupplierAndFacePrice(supplier, facePrice);
		ObjectUtil.convertList(l, list, SupplierProductDto.class);
		return DubboResult.successResult(list);
	}

	@Override
	public DubboResult<List<SupplierProductDto>> findBySupplierAndMobileAndProvince(
			String supplier, String mobile, String province) {
		List<SupplierProductDto> list = new ArrayList<SupplierProductDto>();
		List<SupplierProductEntity> l = supplierProductsService.findBySupplierAndMobileAndProvince(supplier, mobile, province);
		ObjectUtil.convertList(l, list, SupplierProductDto.class);
		return DubboResult.successResult(list);
	}

	@Override
	public DubboResult<List<SupplierProductDto>> findAllBySupplierOrderByNameAndFacePrice(
			String supplier) {
		List<SupplierProductDto> list = new ArrayList<SupplierProductDto>();
		List<SupplierProductEntity> l = supplierProductsService.findAllBySupplierOrderByNameAndFacePrice(supplier);
		ObjectUtil.convertList(l, list, SupplierProductDto.class);
		return DubboResult.successResult(list);
	}

	@Override
	public DubboResult<List<SupplierProductDto>> findAllBySupplierOrderByProvinceAndFacePrice(
			String supplier) {
		List<SupplierProductDto> list = new ArrayList<SupplierProductDto>();
		List<SupplierProductEntity> l = supplierProductsService.findAllBySupplierOrderByProvinceAndFacePrice(supplier);
		ObjectUtil.convertList(l, list, SupplierProductDto.class);
		return DubboResult.successResult(list);
	}

	@Override
	public DubboResult<List<SupplierProductDto>> findAllBySupplierAndGameId(
			String supplier, String gameId) {
		List<SupplierProductDto> list = new ArrayList<SupplierProductDto>();
		List<SupplierProductEntity> l = supplierProductsService.findAllBySupplierAndGameId(supplier, gameId);
		ObjectUtil.convertList(l, list, SupplierProductDto.class);
		return DubboResult.successResult(list);
	}

	@Override
	public DubboResult<List<SupplierProductDto>> findAllByIds(List<Long> ids) {
		List<SupplierProductDto> list = new ArrayList<SupplierProductDto>();
		List<SupplierProductEntity> l = supplierProductsService.findAllByIds(ids);
		ObjectUtil.convertList(l, list, SupplierProductDto.class);
		return DubboResult.successResult(list);
	}

	@Override
	public void insert(SupplierProductDto supplierProductDO) {
		SupplierProductEntity s = new SupplierProductEntity();
		ObjectUtil.convert(supplierProductDO, s);
		supplierProductsService.insert(s);
	}

	@Override
	public void update(SupplierProductDto supplierProductDO) {
		SupplierProductEntity s = new SupplierProductEntity();
		ObjectUtil.convert(supplierProductDO, s);
		supplierProductsService.update(s);
		
	}

	@Override
	public DubboResult<SupplierProductDto> find(Long id) {
		SupplierProductEntity s = supplierProductsService.find(id);
		SupplierProductDto ret =  new SupplierProductDto();
		ObjectUtil.convert(s, ret);
		return DubboResult.successResult(ret);
	}

}
