/**
 * Project Name:developer-center-biz File Name:RemoteTagServiceImpl.java Package
 * Name:cn.com.duiba.developer.center.biz.remoteservice.impl Date:2016年8月16日上午9:59:26 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.developer.center.biz.remoteservice.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.AppTagDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteTagService;
import cn.com.duiba.developer.center.biz.bo.TagBo;
import cn.com.duiba.developer.center.biz.entity.TagEntity;
import cn.com.duiba.developer.center.biz.service.credits.TagsService;
import cn.com.duiba.developer.center.common.tools.AppLogUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.google.common.base.Function;
import com.google.common.collect.Lists;

/**
 * ClassName:RemoteTagServiceImpl <br/>
 * Date: 2016年8月16日 上午9:59:26 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class RemoteTagServiceImpl implements RemoteTagService {

    private static Logger log = LoggerFactory.getLogger(RemoteTagServiceImpl.class);
    @Autowired
    private TagsService   tagsService;

    @Autowired
    private TagBo         tagBo;

    @Override
    public DubboResult<List<AppTagDto>> getRecommendedTags(final Long appId) {
        try {
            List<TagEntity> tags = tagsService.findAllTags();
            final List<Long> shieldTagIds = tagsService.findShieldTagsByAppId(appId);
            List<AppTagDto> appTagList = Lists.transform(tags, new Function<TagEntity, AppTagDto>() {

                @Override
                public AppTagDto apply(TagEntity input) {
                    AppTagDto tagDto = new AppTagDto();
                    tagDto.setAppId(appId);
                    tagDto.setTagId(input.getId());
                    tagDto.setTagName(input.getName());
                    if (shieldTagIds.contains(input.getId())) {
                        tagDto.setShield(true);
                    }
                    return tagDto;
                }
            });
            return DubboResult.successResult(appTagList);
        } catch (Exception e) {
            AppLogUtil.error(log, "getRecommendedTags failed, appId={}", appId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Void> setShieldTags(Long appId, boolean autoRecommend, List<Long> tagids) {
        try {
            tagBo.setShieldTags(appId, autoRecommend, tagids);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            AppLogUtil.error(log, "invoke setShieldTags failed, appId={}, autoRecommend={}, tagids={}", appId,
                             autoRecommend, tagids, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}
