package cn.com.duiba.developer.center.biz.remoteservice.statistics;

import cn.com.duiba.developer.center.api.domain.dto.statistics.CreditsDistributionDto;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppCreditsDistributionDto;
import cn.com.duiba.developer.center.api.remoteservice.statistics.RemoteOdpsAppCreditsDistributionService;
import cn.com.duiba.developer.center.biz.service.statistics.OdpsAppCreditsDistributionService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by wenqi.huang on 16/8/2.
 */
@Service
public class RemoteOdpsAppCreditsDistributionServiceImpl implements RemoteOdpsAppCreditsDistributionService {
    @Resource
    private OdpsAppCreditsDistributionService odpsAppCreditsDistributionService;

    @Override
    public DubboResult<OdpsAppCreditsDistributionDto> findAppCreditsDistributionByAppIdAndDay(Long appId, String day) {
        return DubboResult.successResult(odpsAppCreditsDistributionService.findAppCreditsDistributionByAppIdAndDay(appId, day));
    }

    @Override
    public DubboResult<List<CreditsDistributionDto>> getAppCreditsDistributionByAppIdAndDay(Long appId, Date day) {
        return DubboResult.successResult(odpsAppCreditsDistributionService.getAppCreditsDistributionByAppIdAndDay(appId, day));
    }

}
