package cn.com.duiba.developer.center.biz.runnble;


import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.biz.service.manager.InternalLetterKeyService;
import cn.com.duiba.developer.center.biz.service.manager.InternalLetterService;
import cn.com.duiba.developer.center.common.constants.DsConstants;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

/**
 * Created by liuyao on 16/7/18.
 */
@Component
@Scope("prototype")
public class InternalLetterTask implements Runnable {
    private static final Logger log= LoggerFactory.getLogger(InternalLetterTask.class);
    @Autowired
    private InternalLetterService internalLetterService;
    @Autowired
    private InternalLetterKeyService internalLetterKeyService;
    @Autowired
    private DeveloperService developerService;

    @NotNull
    private Long letterId;

    @Override
    @Transactional(DsConstants.DATABASE_MANAGER)
    public void run() {
        try{
           ValidatorTool.valid(this);

            InternalLetterDO letterDO = internalLetterService.findForUpdate(letterId);
            if(Objects.equal(null,letterDO)){
                throw new Exception("站内信不存在");
            }
            if(letterDO.getSendStatue() == InternalLetterDO.SendStatue_Push || letterDO.getDeleted()){
                return;
            }
            if(new Date().before(letterDO.getSendTime())){
                return;
            }
            Set<Long> ids = getAllDeveloperIdSet(letterDO);
            //执行推送
            int count = internalLetterKeyService.batchInsert(letterDO, Lists.newArrayList(ids));
            if(ids.size()!=count){
                throw new Exception("站内信推送缺失");
            }
            internalLetterService.updateSendStatue(letterId);
        }catch(Exception e) {
            log.error("站内信发送异常", e);
            throw new RuntimeException(e);//抛出异常让事务回滚
        }
    }

    private Set<Long> getAllDeveloperIdSet(InternalLetterDO letterDO){
        if(Objects.equal(InternalLetterDO.Destinations_All,letterDO.getDestinations())){
            return Sets.newHashSet(developerService.findAllEnbleId());
        }else{
            Splitter spl = Splitter.on(InternalLetterDO.Destinations_SPL_REX).trimResults().omitEmptyStrings();
            Iterator<String> it = spl.split(letterDO.getDestinations()).iterator();
            Set<Long> idSet = Sets.newHashSet();
            while(it.hasNext()){
                try {
                    idSet.add(Long.valueOf(it.next()));
                }catch(NumberFormatException e){
                    continue;
                }
            }
            return idSet;
        }
    }

    public Long getLetterId() {
        return letterId;
    }

    public void setLetterId(Long letterId) {
        this.letterId = letterId;
    }
}
