package cn.com.duiba.developer.center.biz.service.credits;

import cn.com.duiba.developer.center.api.domain.dto.AppBulletinDto;
import cn.com.duiba.developer.center.biz.dao.app.AppBulletinDAO;
import cn.com.duiba.developer.center.biz.entity.AppBulletinEntity;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by liuyao on 16/9/9.
 */
@Service
public class AppBulletinService {
    @Autowired
    private AppBulletinDAO appBulletinDAO;

    public AppBulletinDto createAppBulletinDto(Long appId){
        AppBulletinEntity entity = appBulletinDAO.findWithSimpleByAppId(appId);
        if(entity==null) return null;
        AppBulletinDto dto = new AppBulletinDto(true);
        try{
            BeanUtils.copyProperties(dto,entity);
            if(dto.getPagePath()==AppBulletinDto.PAPE_PATH_NONE){
                dto.setNoticeLink("");
            }
        }catch(Exception e){
            throw new RuntimeException(e);
        }
        return dto;
    }

    public String findContextByAppId(Long appId) {
        return appBulletinDAO.findContextByAppId(appId);
    }
}
