package cn.com.duiba.developer.center.biz.service.credits;

import cn.com.duiba.developer.center.biz.bo.impl.AppBoImpl;
import cn.com.duiba.developer.center.biz.entity.AppNewExtraEntity;
import cn.com.duiba.developer.center.biz.entity.BaseEntity;
import cn.com.duiba.developer.center.biz.entity.KeyValueEntity;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.developer.center.biz.service.entrymanage.EntryManagerService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * Created by liuyao on 2016/11/6.
 */
@Service
public class AppNewExtraService {

    private static final Logger log= LoggerFactory.getLogger(AppNewExtraService.class);
    @Autowired
    private EntryManagerService entryManagerService;
    @Autowired
    private BizEventBus eventBus;

    @PostConstruct
    protected void init(){
        eventBus.register(this);
    }

    /**
     * 监听App创建,指定创建App的来源
     * @return
     */
    @Subscribe
    public void pointAppSourceListener(AppCreateEvent event){
        try{
            Long appId = event.getApp().getId();
            Integer createSource = event.getParams().getCreateSource();
            KeyValueEntity entity = new KeyValueEntity();
            entity.setPropName("createSource");
            entity.setPropValue(createSource.toString());
            entryManagerService.update(appId,AppNewExtraEntity.class,entity);
        }catch(Exception e){
            log.error("app指定来源失败",e);
        }
    }
}
