package cn.com.duiba.developer.center.biz.service.credits.aerosol;


import cn.com.duiba.developer.center.api.domain.dto.AerosolGroupDto;
import cn.com.duiba.developer.center.biz.dao.center_config.AerosolGroupDao;
import cn.com.duiba.developer.center.biz.entity.AerosolGroupEntity;
import cn.com.duiba.developer.center.biz.service.credits.aerosol.AerosolGroupService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;


/**
 * Created by yaocheng on 2016/9/22.
 */
@Service
public class AerosolGroupService{

    @Autowired
    private AerosolGroupDao aerosolGroupDao;

    public Long createAerosolGroup(AerosolGroupDto groupDto) {
        AerosolGroupEntity entity =new AerosolGroupEntity();
        entity.setConfigUrl(groupDto.getConfigUrl());
        entity.setGroupName(groupDto.getGroupName());
        entity.setMd5(groupDto.getMd5());
        entity.setIsShow(false);
        return aerosolGroupDao.insert(entity);
    }

    public int deleteAerosolGroup(Long id) {
        return aerosolGroupDao.delete(id);
    }

    public AerosolGroupEntity findGroupById(Long groupId) {
        return aerosolGroupDao.findGroupById(groupId);
    }

    public List<AerosolGroupEntity> findAerosolGroupList() {
        return aerosolGroupDao.findAerosolGroupList();
    }

    public List<Long> findGroupIdByGroupNameLike(String groupName){
        return aerosolGroupDao.findGroupIdByGroupNameLike(groupName);
    }


    public void updateAerosolGroupShowStatus(Long groupId, Boolean isShow) {
         aerosolGroupDao.updateAerosolGroupShowStatus(groupId, isShow);
    }

	public void updateAerosolGroup(AerosolGroupDto dto) {
		aerosolGroupDao.updateAerosolGroup(dto);
	}


}
