package cn.com.duiba.developer.center.biz.service.credits.floor;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.biz.entity.AppLayoutEntity;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.BaseJson;
import cn.com.duiba.developer.center.biz.service.credits.floor.jsonconfig.FloorSortJson;
import cn.com.duiba.service.exception.BusinessException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by liuyao on 16/7/29.
 */
public interface AppLayoutService {
    /**
     * 新建AppLayout
     * @param appLayout
     * @return 成功 1 失败 0
     */
    public int insert(AppLayoutEntity appLayout);

    /**
     * 开发者更换楼层皮肤
     * @param appId
     * @param skinId
     * @return
     */
    public Integer updateSkin(Long appId, Long skinId, List<FloorSortJson> floorList);

    /**
     * 获取AppLayoutDto ,Service层不做缓存,因为老皮肤依赖AppLayoutBrick
     * @param appId
     * @return AppLayoutDto
     */
    public AppLayoutDto buildAppLayoutByAppId(Long appId);

    /**
     * 
     * 根据appId和floorId更新楼层配置
     * 如果楼层配置不存在，则把配置信息写入到developDataShowJson中；如果楼层配置存在，则更新developDataShowJson中的配置信息
     *
     * @author zhanglihui
     * @param appId
     * @return
     */
    public Integer updateDevFloorConfigByAppId(Long appId,Map<Long,JSONObject> jsonMap);

    /**
     * 更新开发者排序队列
     * @author liuyao
     * @param appId
     * @param sortJson
     * @return
     */
    public Integer updateDevSortJsonByAppId(Long appId, JSONArray sortJson);

    /**
     * 查询使用某个楼层皮肤的开发者数目
     * @param skinId
     * @return
     */
    public Integer useSkinCount(Long skinId);
    /**
     * 查询使用某个楼层皮肤的AppIds
     * @param skinId
     * @return
     */
    public Collection<Long> useSkinAppIds(Long skinId);

    /**
     * 开发者修改主题色(注意请同时修改AppDo中的主题色,直到App表迁移完毕)
     * @param appId
     * @param color
     */
    public void updateThemeColor(Long appId, String color);


    public Class<? extends BaseJson> getBaseJson(Integer floorType);
}
