package cn.com.duiba.developer.center.biz.service.credits.floor.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.biz.dao.floor.CreditsFloorSkinSpecifyDao;
import cn.com.duiba.developer.center.biz.service.credits.floor.CreditsFloorSkinSpecifyService;

/**
 * Created by suyuanlong on 16/8/16.
 */
@Service
public class CreditsFloorSkinSpecifyServiceImpl implements CreditsFloorSkinSpecifyService {

    @Autowired
    private CreditsFloorSkinSpecifyDao creditsFloorSkinSpecifyDao;

    @Override
    public List<Long> selectSpecifyAppIdsBySkinId(Long skinId) {
        List<Long> list = creditsFloorSkinSpecifyDao.selectSpecifyAppIdsBySkinId(skinId);
        return list;
    }

    @Override
    public int findSkinOpenSpecifyCount(Long skinId) {
        return creditsFloorSkinSpecifyDao.findSkinOpenSpecifyCount(skinId);
    }

    @Override
    public int addAppSpecify(Long appId, Long skinId) {
        return creditsFloorSkinSpecifyDao.insertAppSpecify(appId,skinId);
    }

    @Override
    public List<Long> selectSkinIdBySpecifyAppId(Long appId) {
        return creditsFloorSkinSpecifyDao.selectSkinIdBySpecifyAppId(appId);
    }
}
