package cn.com.duiba.developer.center.biz.service.credits.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashAuditDto;
import cn.com.duiba.developer.center.biz.dao.developer.AmbDeveloperWithdrawCashAuditDao;
import cn.com.duiba.developer.center.biz.entity.AmbDeveloperWithdrawCashAuditEntity;
import cn.com.duiba.developer.center.biz.service.credits.AmbDeveloperWithdrawCashAuditService;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by ZQian on 2016/8/9.
 */
@Service
public class AmbDeveloperWithdrawCashAuditServiceImpl implements AmbDeveloperWithdrawCashAuditService {

    @Autowired
    private AmbDeveloperWithdrawCashAuditDao ambDeveloperWithdrawCashAuditDao;

    @Override
    public void insert(AmbDeveloperWithdrawCashAuditDto ambDeveloperWithdrawCashAuditDto) {
        AmbDeveloperWithdrawCashAuditEntity entity = BeanUtils.copy(ambDeveloperWithdrawCashAuditDto, AmbDeveloperWithdrawCashAuditEntity.class);
        ambDeveloperWithdrawCashAuditDao.insert(entity);
        ambDeveloperWithdrawCashAuditDto.setId(entity.getId());
    }

    @Override
    public AmbDeveloperWithdrawCashAuditDto findById(Long id) {
        return BeanUtils.copy(ambDeveloperWithdrawCashAuditDao.findById(id),AmbDeveloperWithdrawCashAuditDto.class);
    }

    @Override
    public AmbDeveloperWithdrawCashAuditDto findValidPassAudit(Long developerId, String cashType) {
        return BeanUtils.copy(ambDeveloperWithdrawCashAuditDao.findValidPassAudit(developerId, cashType),AmbDeveloperWithdrawCashAuditDto.class);
    }

    @Override
    public AmbDeveloperWithdrawCashAuditDto findAuditing(Long developerId, String cashType) {
        return BeanUtils.copy(ambDeveloperWithdrawCashAuditDao.findAuditing(developerId, cashType),AmbDeveloperWithdrawCashAuditDto.class);
    }

    @Override
    public void disableValidPassAudit(Long developerId, String cashType) {
        ambDeveloperWithdrawCashAuditDao.disableValidPassAudit(developerId, cashType);
    }

    @Override
    public int updateStatusCreateToWait(Long auditId) {
        return ambDeveloperWithdrawCashAuditDao.updateStatusCreateToWait(auditId);
    }

    @Override
    public List<AmbDeveloperWithdrawCashAuditDto> findByIds(List<Long> auditIds) {
        return BeanUtils.copyList(ambDeveloperWithdrawCashAuditDao.findByIds(auditIds),AmbDeveloperWithdrawCashAuditDto.class);
    }
}
