/**
 * Project Name:developer-center-biz File Name:AppBannerServiceImpl.java Package
 * Name:cn.com.duiba.developer.center.biz.service.credits.impl Date:2016年8月10日下午9:48:58 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.developer.center.biz.service.credits.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.biz.dao.app.AppBannerDao;
import cn.com.duiba.developer.center.biz.entity.AppBannerEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppBannerService;
import cn.com.duiba.developer.center.common.constants.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;

/**
 * ClassName:AppBannerServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年8月10日 下午9:48:58 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class AppBannerServiceImpl implements AppBannerService {

    @Autowired
    private CacheClient  memcachedClient;
    @Autowired
    private AppBannerDao appBannerDao;

    @Override
    public AppBannerEntity find(Long id) {
        AppBannerEntity d = memcachedClient.get(getCacheKeyById(id));
        if (d == null) {
            d = appBannerDao.find(id);
            if (d != null) {
                memcachedClient.set(getCacheKeyById(id), d, 300);
            }
        }
        return d;
    }

    @Override
    public Integer updateByIdAndAppId(AppBannerEntity appBanner) {
        Integer ret = appBannerDao.updateByIdAndAppId(appBanner);
        appBanner = this.find(appBanner.getId());
        removeCacheByAppId(appBanner.getAppId());
        memcachedClient.remove(getCacheKeyById(appBanner.getId()));
        return ret;
    }

    @Override
    public void insert(AppBannerEntity appBanner) {
        appBannerDao.insert(appBanner);
        removeCacheByAppId(appBanner.getAppId());
    }

    @Override
    public Integer findMaxPlayload(Long appId, String type) {
        return appBannerDao.findMaxPlayload(appId, type);
    }

    @Override
    public List<AppBannerEntity> findAllByAppId(Long appId, Boolean deleted) {
        return appBannerDao.findAllByAppId(appId, deleted);
    }

    @Override
    public List<AppBannerEntity> findAllByAppIdDeleteAndType(Long appId, String type, Boolean deleted) {
        return appBannerDao.findAllByAppIdDeleteAndType(appId, type, deleted);
    }

    @Override
    public List<AppBannerEntity> findListBetweenPayload(Long appId, String type, Integer startPayload,
                                                        Integer endPayload) {
        return appBannerDao.findListBetweenPayload(appId, type, startPayload, endPayload);
    }

    @Override
    public List<AppBannerEntity> findHomeBannerByCache(Long appId, boolean deleted) {
        String key = getCacheKeyByAppId(appId);
        List<AppBannerEntity> list = memcachedClient.get(key);
        if (list == null) {
            list = findAllByAppId(appId, deleted);
            if (list != null) {
                memcachedClient.set(key, list, 120);
            }
        }
        return list;
    }

    private String getCacheKeyById(Long id) {
        return CacheConstants.KEY_APP_BANNER_ID + id;
    }

    private String getCacheKeyByAppId(Long appId) {
        return CacheConstants.KEP_APP_BANNERS + appId;
    }

    private void removeCacheByAppId(Long appId) {
        memcachedClient.remove(getCacheKeyByAppId(appId));
        String cacheKey = CacheConstants.MS_HOME_ITEM + "-" + appId;
        memcachedClient.set(cacheKey, System.currentTimeMillis(), 3600);
    }

    @Override
    public List<AppBannerEntity> findBannerByItemId(Long appId, Long appItemId, String type) {
        return appBannerDao.findBannerByItemId(appId, appItemId, type);
    }

}
