package cn.com.duiba.developer.center.biz.service.credits.impl;

import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.entity.AppExtraEntity;
import cn.com.duiba.developer.center.biz.dao.app.AppExtraDao;
import cn.com.duiba.developer.center.biz.entity.AppLayoutEntity;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.developer.center.biz.service.credits.AppExtraService;
import cn.com.duiba.developer.center.common.constants.CacheConstants;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.wolf.cache.CacheClient;
import com.alibaba.fastjson.JSONObject;
import com.google.common.eventbus.Subscribe;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;

/**
 * Created by liuyao on 16/7/18.
 */
@Service
public class AppExtraServiceImpl implements AppExtraService {
    @Resource
    private AppExtraDao appExtraDao;
    @Resource
    private CacheClient cacheClient;
    @Resource
    private BizEventBus eventBus;

    @PostConstruct
    public void init(){
        eventBus.register(this);
    }

    @Subscribe
    public void createAppListener(AppCreateEvent event) {
        AppDO app = event.getApp();
        AppExtraEntity entity = new AppExtraEntity(true);
        entity.setAppId(app.getId());
        insert(entity);
    }


    private String getSimpleCacheKeyByAppId(Long appId) {
        return CacheConstants.KEY_APP_EXTRA_SIMPLE_BY_APP_ID + appId;
    }

    private String getProgramCacheKeyByAppId(Long appId) {
        return CacheConstants.KEY_APP_EXTRA_PROGRAM_BY_APP_ID + appId;
    }

    @Override
    public AppExtraEntity findByAppId(Long appId) {
        String key = getSimpleCacheKeyByAppId(appId);
        AppExtraEntity d = cacheClient.get(key);
        if (d == null) {
            d = appExtraDao.findByAppId(appId);
            cacheClient.set(key, d, 300);
        }
        return d;
    }

    @Override
    public AppExtraEntity findByAppIdIfNullAutoCreate(Long appId) {
        AppExtraEntity appExtra = findByAppId(appId);
        if (appExtra == null) {
            appExtra = new AppExtraEntity(true);
            appExtra.setAppId(appId);
            insert(appExtra);
            appExtra = findByAppId(appId);
        }
        return appExtra;
    }

    @Override
    public void insert(AppExtraEntity appExtraEntity) {
        appExtraDao.insert(appExtraEntity);
    }

    @Override
    public AppExtraEntity find(Long id) {
        return appExtraDao.find(id);
    }

    @Override
    public Integer update(AppExtraEntity appExtraEntity) {
        Long appId = appExtraEntity.getAppId();
        if (appId == null) {
            AppExtraEntity d = find(appExtraEntity.getId());
            if (d != null) {
                appId = d.getAppId();
            }
        }
        Integer ret = appExtraDao.update(appExtraEntity);
        cacheClient.remove(getSimpleCacheKeyByAppId(appId));
        return ret;
    }

    @Override
    public void insertAppConfig(AppExtraEntity appExtraEntity) {
        appExtraDao.insertAppConfig(appExtraEntity);
    }

    @Override
    public Integer updateAppConfig(Long appId, String entranceDesc, String callLoginProgram) {
        Integer ret = appExtraDao.updateAppConfig(appId, entranceDesc, callLoginProgram);
        cacheClient.remove(getSimpleCacheKeyByAppId(appId));
        cacheClient.remove(getProgramCacheKeyByAppId(appId));
        return ret;
    }

    @Override
    public String findCallLoginProgramByAppId(Long appId) {
        String key = getProgramCacheKeyByAppId(appId);
        String ret = cacheClient.get(key);
        if (ret == null) {
            ret = appExtraDao.findCallLoginProgramByAppId(appId);
            cacheClient.set(key, ret, 300);
        }
        return ret;
    }

    @Override
    public List<AppExtraEntity> findByAppIds(List<Long> appIds) {
        return appExtraDao.findByAppIds(appIds);
    }

    @Override
    public int updateAppPerson(Long appId, String appPerson) {
        return appExtraDao.updateAppPerson(appId, appPerson);
    }

    @Override
    public List<Long> findByAppPerson(String name) {
        return appExtraDao.findByAppPerson(name);
    }

    @Override
    public int updateAddCreditsUrl(Long appId, String addCreditsUrl) {
        int ret = appExtraDao.updateAddCreditsUrl(appId,addCreditsUrl);
        cacheClient.remove(getSimpleCacheKeyByAppId(appId));
        cacheClient.remove(getProgramCacheKeyByAppId(appId));
        return ret;
    }
}
