package cn.com.duiba.developer.center.biz.service.credits.impl;

import java.util.*;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.paramquery.ADeveloperQueryEntity;
import cn.com.duiba.developer.center.biz.dao.developer.DeveloperDao;
import cn.com.duiba.developer.center.biz.dao.developer.RemainingMoneyDao;
import cn.com.duiba.developer.center.biz.entity.DeveloperEntity;
import cn.com.duiba.developer.center.biz.service.credits.DeveloperService;
import cn.com.duiba.developer.center.common.constants.CacheConstants;
import cn.com.duiba.developer.center.common.tools.SwitchTool;
import cn.com.duiba.wolf.cache.CacheClient;

/**
 * Created by liuyao on 16/7/18.
 */
@Service
public class DeveloperServiceImpl implements DeveloperService {
    @Resource
    private DeveloperDao developerDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id){
        return CacheConstants.KEY_DEVELOPER + id;
    }

    @Override
    public void insertDeveloper(DeveloperEntity developer) {
        developerDao.insert(developer);
    }

    @Override
    public DeveloperEntity findByEmail(String email) {
        return developerDao.findByEmail(email);
    }

    @Override
    public DeveloperEntity find(Long id) {
        DeveloperEntity d = cacheClient.get(getCacheKeyById(id));
        if(d == null){
            d = developerDao.find(id);
            cacheClient.set(getCacheKeyById(id), d, 300);
        }
        return d;
    }

    @Override
    public List<DeveloperEntity> findByEmailLike(String email) {
        return developerDao.findByEmailLike(email);
    }

    @Override
    public List<DeveloperEntity> findAllByIdList(Collection<Long> idList) {
        if(idList.isEmpty()){
            return Collections.emptyList();
        }
        return developerDao.findAllByIdList(new ArrayList<Long>(idList));
    }

    @Override
    public List<Long> findAllEnbleId() {
        return developerDao.findAllEnbleId();
    }

    @Override
    public List<DeveloperEntity> findDeveloperPage(ADeveloperQueryEntity queryEntity) {
        return developerDao.findDeveloperPage(queryEntity);
    }

    @Override
    public Long findDeveloperPageCount(ADeveloperQueryEntity queryEntity) {
        return developerDao.findDeveloperPageCount(queryEntity);
    }

    @Override
    public int updateDeveloperSwitch(SwitchTool tool) {
        int ret = developerDao.updateDeveloperSwitch(tool.getId(),tool.getSwicthValue());
        cacheClient.remove(getCacheKeyById(tool.getId()));
        return ret;
    }

    @Override
    public int updateLastRemindTime(Long id, Date lastRemindTime) {
        int ret =  developerDao.updateLastRemindTime(id, lastRemindTime);
        cacheClient.remove(getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateRemindMoneyNameCompany(Long id, Integer remindMoney, String name, String company) {
        int ret =  developerDao.updateRemindMoneyNameCompany(id, remindMoney, name, company);
        cacheClient.remove(getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updatePassword(Long id, String password) {
        int ret =  developerDao.updatePassword(id, password);
        cacheClient.remove(getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateVerifyAndEnable(Long id, boolean verify, boolean enable) {
        int ret = developerDao.updateVerifyAndEnable(id, verify, enable);
        cacheClient.remove(getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateJson(Long id, String jsonStr) {
        return developerDao.updateJson(id, jsonStr);
    }
}
