package cn.com.duiba.developer.center.biz.service.entrymanage;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.PostConstruct;

import cn.com.duiba.developer.center.biz.dao.app.impl.AppNewEntityDaoImpl;
import cn.com.duiba.developer.center.biz.entity.AppNewExtraEntity;
import cn.com.duiba.developer.center.biz.service.credits.AppNewExtraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import cn.com.duiba.developer.center.biz.dao.KeyValueDao;
import cn.com.duiba.developer.center.biz.entity.BaseEntity;
import cn.com.duiba.developer.center.biz.entity.KeyValueEntity;
import cn.com.duiba.developer.center.common.tools.ClassUtil;

/**
 * Created by liuyao on 2016/11/5.
 * EntryManagerService 依赖 KeyValueDao 接口,但是还未使用KeyValueDao中所有方法
 * KeyValueDao定义出来的多余的方法是为将来的业务做预留
 */
@Service
public class EntryManagerService implements ApplicationContextAware {
    private static final Logger log= LoggerFactory.getLogger(EntryManagerService.class);
    private ApplicationContext ctx;

    @Autowired
    private EntryTransformFactory entryTransformFactory;

    private Map<Class<? extends BaseEntity>,KeyValueDao> daoMap = Maps.newHashMap();

    @PostConstruct
    public void init(){
        daoMap.put(AppNewExtraEntity.class,ctx.getBean(AppNewEntityDaoImpl.class));
    }

    /**
     * 默认将所有的属性全查出来
     * @param bizId
     * @param clazz
     * @param <T>
     * @return
     */
    public <T extends BaseEntity> T find(Long bizId,Class<T> clazz){
        if(!daoMap.containsKey(clazz)){
            throw new RuntimeException(clazz.getName()+"没有对应的DAO");
        }
        List<String> propNames = entryTransformFactory.getAllPropNameButBizId(clazz);
        return findEntityByPropNames(bizId,clazz,propNames);
    }

    public <T extends BaseEntity> String findOneEntry(Long bizId,Class<T> clazz,String propName){
        if(!daoMap.containsKey(clazz)){
            throw new RuntimeException(clazz.getName()+"没有对应的DAO");
        }
        KeyValueDao dao = daoMap.get(clazz);
        KeyValueEntity entry = dao.findOneEntry(bizId,propName);
        if(entry==null){
            return null;
        }else{
            return entry.getPropValue();
        }

    }

    public <T extends BaseEntity> T findEntityByPropNames(Long bizId,Class<T> clazz,List<String> propNames){
        if(!daoMap.containsKey(clazz)){
            throw new RuntimeException(clazz.getName()+"没有对应的DAO");
        }
        KeyValueDao dao = daoMap.get(clazz);
        List<KeyValueEntity> entrys = dao.findEntrys(bizId,propNames);
        return entryTransformFactory.getPojoEntity(bizId,entrys,clazz);
    }

    public <T extends BaseEntity> int update(Long bizId,Class<T> clazz,KeyValueEntity entrys){
        List<KeyValueEntity> list = Lists.newArrayList(entrys);
        return update(bizId,clazz,list);
    }
    /**
     * 这里没有提供直接保存BaseEntity的update,因为在我们的工程本身就不建议使用更新整个BaseEntity
     * 而是根据业务需要指定所要更新的字段
     * @param bizId
     * @param clazz
     * @param entrys
     * @param <T>
     * @return
     */
    public <T extends BaseEntity> int update(Long bizId,Class<T> clazz,List<KeyValueEntity> entrys){
        if(!daoMap.containsKey(clazz)){
            throw new RuntimeException(clazz.getName()+"没有对应的DAO");
        }
        if(entrys.isEmpty()){
            return 0;
        }
        KeyValueDao dao = daoMap.get(clazz);
        int ret = 0;
        if(entrys.size()==1){
            KeyValueEntity entry = entrys.get(0);
            ret = dao.updateOneEntry(bizId,entry.getPropName(),entry.getPropValue());
        }else{
            ret = dao.updateEntrys(bizId,entrys);
        }
        if(ret<entrys.size()){
            Set<String> hasPropNames = Sets.newHashSet(dao.findAllPropNames(bizId));
            List<KeyValueEntity> needInserts = Lists.newArrayList();
            for(KeyValueEntity it:entrys){
                if(!hasPropNames.contains(it.getPropName())){
                    it.setBizId(bizId);
                    needInserts.add(it);
                }
            }
            ret = ret + dao.insertEntrys(needInserts);
        }
        return ret;
    }



    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }
}
