package cn.com.duiba.developer.center.biz.service.entrymanage;

import cn.com.duiba.developer.center.biz.entity.BaseEntity;
import cn.com.duiba.developer.center.biz.entity.KeyValueEntity;
import com.google.common.base.*;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * Created by liuyao on 2016/11/6.
 */
@Service
public class EntryTransformFactory {

    private BeanUtilsBean beanUtils;

    private ConcurrentMap<Class<? extends BaseEntity>, String> bizIdPropNameCache = new ConcurrentHashMap<>();

    private ConcurrentMap<Class<? extends BaseEntity>, List<String>> propNameMap = new ConcurrentHashMap<>();

    private Set<String> noBizClassblack = Sets.newHashSet();

    /**
     * 工厂初始化
     */
    @PostConstruct
    public void init(){
        ConvertUtilsBean convertUtils = new ConvertUtilsBean();
        DateConverter dateConverter = new DateConverter();
        convertUtils.register(dateConverter,Date.class);
        beanUtils = new BeanUtilsBean(convertUtils,new PropertyUtilsBean());
    }

    /**
     * 将KeyValu转化成一个BaseEntity
     * @param entryList
     * @param clazz
     * @param <T>
     * @return
     */
    public <T extends BaseEntity> T getPojoEntity(Long bizId,List<KeyValueEntity> entryList, Class<T> clazz){
        Map<String,String> propMap = Maps.newHashMap();
        try{
            T entity = clazz.newInstance();
            if(entryList.isEmpty()){
                return entity;
            }
            for(KeyValueEntity entry : entryList){
                propMap.put(entry.getPropName(),entry.getPropValue());
            }
            beanUtils.populate(entity,propMap);
            String bizIdName = getBizIdPropName(clazz);
            beanUtils.setProperty(entity,bizIdName,bizId);
            return entity;
        }catch (Exception e){
            throw new RuntimeException(e);
        }
    }

    public List<KeyValueEntity> getEntryList(BaseEntity entity){
        String bizIdName = getBizIdPropName(entity.getClass());
        Long bizId = null;
        try{
            if(StringUtils.isNotBlank(bizIdName)){
                bizId = Long.valueOf(beanUtils.getProperty(entity,bizIdName));
            }
            List<KeyValueEntity> list = Lists.newArrayList();
            List<String> propNames = getAllPropNameButBizId(entity.getClass());
            for(String name:propNames){
                String propValue = beanUtils.getProperty(entity,name);
                if(StringUtils.isNotBlank(propValue)){
                    KeyValueEntity entry = new KeyValueEntity();
                    entry.setBizId(bizId);
                    entry.setPropName(name);
                    entry.setPropValue(propValue);
                    list.add(entry);
                }
            }
            return list;
        }catch(Exception e){
            throw new RuntimeException(e);
        }
    }

    private String getBizIdPropName(Class<? extends BaseEntity> clazz){
        if(noBizClassblack.contains(clazz.getName())){
            return null;
        }
        if(bizIdPropNameCache.containsKey(clazz)){
            return bizIdPropNameCache.get(clazz);
        }
        compile(clazz);
        return bizIdPropNameCache.get(clazz);
    }

    public List<String> getAllPropNameButBizId(Class<? extends BaseEntity> clazz){
        if(propNameMap.containsKey(clazz)){
            return propNameMap.get(clazz);
        }
        compile(clazz);
        return propNameMap.get(clazz);
    }

    private void compile(Class<? extends BaseEntity> clazz){
        synchronized (clazz){
            Field[] fields =  clazz.getDeclaredFields();
            List<String> propNames = Lists.newArrayList();
            String bizId = null;
            for(Field f : fields){
                //1、获取属性上的指定类型的注释
                Annotation annotation = f.getAnnotation(BizId.class);
                if(annotation!=null){
                    bizId = f.getName();
                }else{
                    propNames.add(f.getName());
                }
            }
            propNameMap.putIfAbsent(clazz,propNames);
            if(StringUtils.isNotBlank(bizId)){
                bizIdPropNameCache.putIfAbsent(clazz,bizId);
            }else{

                noBizClassblack.add(clazz.getName());
            }
        }
    }

}
