package cn.com.duiba.developer.center.biz.service.manager.impl;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.biz.dao.internalletter.InternalLetterDao;
import cn.com.duiba.developer.center.biz.service.manager.InternalLetterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * Created by liuyao on 16/7/18.
 */
@Service
public class InternalLetterServiceImpl implements InternalLetterService {
    @Autowired
    private InternalLetterDao internalLetterDao;

    @Override
    public InternalLetterDO find(Long id) {
        return internalLetterDao.find(id);
    }

    @Override
    public InternalLetterDO findForUpdate(Long id){
        return internalLetterDao.findForUpdate(id);
    }

    @Override
    public int insert(InternalLetterDO letter) {
        return internalLetterDao.insert(letter);
    }

    @Override
    public int update(InternalLetterDO letter) {
        return internalLetterDao.update(letter);
    }

    @Override
    public int delete(InternalLetterDO letter) {
        if(Objects.equals(letter.getSendStatue(),InternalLetterDO.SendStatue_Push)){
            return internalLetterDao.updateDeleted(letter.getId());//发送的形式删除
        }else{
            return internalLetterDao.delete(letter);//没发送的直接删除
        }

    }

    @Override
    public List<InternalLetterDO> findListPage(PageQueryEntity param) {
        return internalLetterDao.findListPage(param);
    }

    @Override
    public long findCountPage(PageQueryEntity param) {
        return internalLetterDao.findCountPage(param);
    }

    @Override
    public int updateSendStatue(Long id) {
        return internalLetterDao.updateSendStatue(id);
    }

    @Override
    public List<Long> findAllCanPushIds() {
        return internalLetterDao.findAllCanPushIds();
    }

}
