package cn.com.duiba.developer.center.biz.service.manager.impl;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.developer.center.api.domain.dto.ItemActivityExtDto;
import cn.com.duiba.developer.center.biz.dao.manager.ItemActivityExtDao;
import cn.com.duiba.developer.center.biz.entity.ItemActivityExtEntity;
import cn.com.duiba.developer.center.biz.service.manager.ItemActivityExtService;
import cn.com.duiba.wolf.utils.ObjectUtil;

import com.alibaba.fastjson.JSON;

@Service
public class ItemActivityExtServiceImpl implements ItemActivityExtService {

    @Autowired
    ItemActivityExtDao itemActivityExtDao;

    @Override
    public void add(ItemActivityExtDto iaeDto) {
        ItemActivityExtEntity iae = convertToEntity(iaeDto);
        if(itemActivityExtDao.select(iaeDto.getSourceId(), iaeDto.getSourceType()) != null){
            itemActivityExtDao.update(iae);
        }else{
            itemActivityExtDao.insert(iae);
        }
    }

    @Override
    public void edit(ItemActivityExtDto iaeDto) {
        ItemActivityExtEntity iae = convertToEntity(iaeDto);
        itemActivityExtDao.update(iae);
    }

    @SuppressWarnings("unchecked")
    @Override
    public Map<String, String> get(Long sourceId, String sourceType) {
        ItemActivityExtEntity iaee = itemActivityExtDao.select(sourceId, sourceType);
        if (iaee == null) {
            return null;
        }
        return JSON.parseObject(iaee.getExtParam(), Map.class);
    }

    private ItemActivityExtEntity convertToEntity(ItemActivityExtDto itemActivityExtDto) {
        if (itemActivityExtDto == null) {
            return null;
        }
        ItemActivityExtEntity entity = new ItemActivityExtEntity();
        ObjectUtil.convert(itemActivityExtDto, entity);
        entity.setExtParam(JSON.toJSONString(itemActivityExtDto.getExtParam()));
        return entity;
    }

}
