package cn.com.duiba.developer.center.biz.service.schedule;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.AppPushTaskDto;
import cn.com.duiba.developer.center.api.domain.enums.AppPushStatusEnum;

/**
 * @Author【yaocheng@duiba.com.cn】
 * @Date 2016/11/8 10:09
 */
public interface AppPushTaskService {

    /**
     * 查询可编辑的app推送任务</br> 查询条件： status = 'INIT'
     *
     * @author yaocheng
     * @return
     * @since JDK 1.6
     */
    List<AppPushTaskDto> queryAppPushTaskForEdit(Long duibaTaskId);

    /**
     * 创建计划任务
     * 
     * @param appPushTasks
     */
    void create(List<AppPushTaskDto> appPushTasks);

    /**
     * 更新计划任务
     * 
     * @param appPushTasks
     */
    void update(List<AppPushTaskDto> appPushTasks);

    /**
     * 查询待执行的app推送任务<br/>
     *
     * @author zhanglihui
     * @return
     */
    List<AppPushTaskDto> queryAppPushTaskToExec();

    /**
     * 更新计划任务状态<br/>
     *
     * @author zhanglihui
     * @param appPushTaskId 计划任务主键
     * @param status 目标状态{@link AppPushStatusEnum}
     */
    void updateAppPushTaskStatus(long appPushTaskId, String status);

    /**
     * 更新计划任务执行时间
     *
     * @author zhanglihui
     * @param appPushTaskId 任务主键
     * @param pushTime 执行时间
     * @return
     */
    void updateAppPushTaskTime(long appPushTaskId, Date pushTime);

    /**
     * 立即执行计划任务
     * 
     * @param duibaTaskId
     * @return
     */
    void executeRightNow(Long duibaTaskId);

    /**
     * 删除计划任务
     * 
     * @param duibaTaskId
     */
    void delete(Long duibaTaskId);

    /**
     * 计划任务列表查询
     * 
     * @param pageIndex
     * @param pageSize
     * @param appPushTaskDto
     * @return
     */
    List<AppPushTaskDto> findScheduledTaskList(int pageIndex, int pageSize, AppPushTaskDto appPushTaskDto);

    /**
     * 计划任务列表count
     * 
     * @param appPushTaskDto
     * @return
     */
    Integer findScheduledTaskListCount(AppPushTaskDto appPushTaskDto);

    /**
     * 计划任务列表下app查询
     * 
     * @param pageIndex
     * @param pageSize
     * @param appPushTaskDto
     * @return
     */
    List<AppPushTaskDto> findScheduledTaskAppList(int pageIndex, int pageSize);

    /**
     * 计划任务列表下app count
     * 
     * @param appPushTaskEntity
     * @return
     */
    Integer findScheduledTaskAppCount();

    /**
     * 开启计划任务，并且将tb_credits_app_push_task状态置为待执行（TO_EXEC）
     *
     * @param duibaTaskId 兑吧计划任务ID
     */
    void openPushTask(Long duibaTaskId);

    /**
     * 关闭计划任务，并且将tb_credits_app_push_task状态置为初始化（INIT）
     *
     * @param duibaTaskId 兑吧计划任务ID
     */
    void closePushTask(Long duibaTaskId);

    /**
     * 更新计划任务扩展信息<br/>
     *
     * @author zhanglihui
     * @param appPushTaskId 任务主键
     * @param key 需要放入extParam中的键
     * @param value 需要放入extParam中的值
     * @return
     */
    void updateExtParamById(long appPushTaskId, String key, String value);
    /**
     * 批量查询计划任务下app数量
     * @param pushTaskIds
     * @return
     */
    Map<Long,Integer> findBatchScheduledTaskAppNums(List<Long> pushTaskIds);

}
