package cn.com.duiba.developer.center.common.dao;

import cn.com.duiba.developer.center.common.constants.DsConstants;

/**
 * Created by liuyao on 16/7/15.
 */
public enum  DatabaseSchema {
    /**
     *手机端credits_dev主库
     */
    CREDITS(DsConstants.DATABASE_CREDITS),
    /**
     *credits_game库
     */
    CREDITS_GAME(DsConstants.DATABASE_CREDITS_GAME),
    /**
     *ngame库
     */
    NGAME(DsConstants.DATABASE_NGAME),
    /**
     *odps_statistics库
     */
    ODPS(DsConstants.DATABASE_ODPS),
    /**
     *guess 库
     */
    GUESS(DsConstants.DATABASE_GUESS),
    /**
     *quizz库
     */
    QUIZZ(DsConstants.DATABASE_QUIZZ),
    /**
     *seckill库
     */
    SECKILL(DsConstants.DATABASE_SECKILL),
    /**
     *creditsActivity库
     */
    CREDITS_ACTIVITY(DsConstants.DATABASE_CREDITS_ACTIVITY),
    /**
     *手机端主库
     */
    GOODS(DsConstants.DATABASE_GOODS),
    /**
     *manager 库
     */
    MANAGER(DsConstants.DATABASE_MANAGER),
    /**
     * consumer库,拥有consumer的1024张分表
     */
    CONSUMER(DsConstants.DATABASE_CONSUMER);

    private String name;

    private DatabaseSchema(String name){
        this.name = name;
    }

    public String getName(){
        return name;
    }

    public static DatabaseSchema nameOf(String name){
        for(DatabaseSchema d : DatabaseSchema.values()){
            if(d.getName().equals(name)){
                return d;
            }
        }
        return null;
    }
}
