package cn.com.duiba.developer.center.common.support;

import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 事件总线
 * listener 可为任意对象
 * 监听方法:只需在监听者的某个方法上加上 @Subscribe 注解,就能让这个方法成为事件的回调方法
 * 订阅:监听方法 根据event的类型来判断是否执行。
 * ex:如果监听的形参为AppDo  当post一个AppDo对象,该方法就会被执行。
 * 当然如果post形参类型的父类,同样能够触发监听
 */
@Component
public class BizEventBus {

    private EventBus eventBus = new EventBus();

    private Set<String> listenerNameSet = Sets.newHashSet();

    public void register(Object listener){
        if(Objects.equal(null,listener))return;
        String listenerName = listener.getClass().getSimpleName();

        listenerNameSet.add(listenerName);
        eventBus.register(listener);
        System.out.println(listenerName+"注册到事件总线");
    }

    public void post(Object event) throws BusinessException {
        ValidatorTool.valid(event);
        eventBus.post(event);
    }

    public void showAllListener(){
        Joiner joiner = Joiner.on(",").skipNulls();
        System.out.println(joiner.join(listenerNameSet));
    }

}
