package cn.com.duiba.developer.center.common.tools;

/**
 * Created by liuyao on 16/7/28.
 * 为了降低位运算开关在的更新时的错误率,统一用此开关工具对位预算开关进行操作
 * 在更新时请尽量取用SwicthTool中的Id
 */
public class SwitchTool {
    private Long id;
    private Integer swicth;

    private SwitchTool(Long id, Integer swicth){
        this.id = id;
        this.swicth = swicth;
    };

    public static SwitchTool getSwitchTool(Long id, Integer swicth){
        return new SwitchTool(id,swicth);
    }

    public void setSwitchByBoundType(int boundType, boolean isOpen){
        if(isOpen){
            openSwitch(boundType);
        }else{
            offSwitch(boundType);
        }
    }

    private void openSwitch(int boundType) {
        int v = 1 << boundType;
        this.swicth = this.swicth | v;
    }

    private void offSwitch(int boundType) {
        int v = 1 << boundType;
        v = ~v;
        this.swicth = this.swicth & v;
    }

    public Long getId(){
        return this.id;
    }

    public Integer getSwicthValue(){
        return this.swicth;
    }


}
