package cn.com.duiba.devops.web.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.devops.web.param.dingtalk.GroupCreateDto;
import cn.com.duiba.devops.web.param.dingtalk.GroupSendMsgDto;
import cn.com.duiba.devops.web.param.dingtalk.GroupUpdateDto;

/**
 * 大雁封装的钉钉remote接口
 * 对应机器人：项目管理小助手
 *
 * @author ykb
 * @date 2022-02-25
 */
@AdvancedFeignClient(qualifier = "remoteDingTalkService")
public interface RemoteDingTalkService {

    /**
     * 群创建
     *
     * @param groupCreateDto 群创建参数
     * @return {@link String}
     */
    String groupCreate(GroupCreateDto groupCreateDto);

    /**
     * 修改群成员
     *
     * @param groupUpdateDto 修改群成员参数
     * @return {@link Boolean}
     */
    Boolean groupUpdateMember(GroupUpdateDto groupUpdateDto);

    /**
     * 群发送消息
     *
     * @param groupSendMsgDto 群消息参数
     * @return {@link Boolean}
     */
    Boolean groupSendMsg(GroupSendMsgDto groupSendMsgDto);

}
