package cn.com.duiba.devops.web.param.amiya;

import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * 大雁项目发群消息参数
 *
 * @author ykb
 * @date 2022-02-28
 */
@Getter
@Setter
@NoArgsConstructor
public class ProjectSendMsgDto implements Serializable {

    private static final long serialVersionUID = 10001010L;

    /**
     * 大雁项目id
     */
    private Long projectId;

    /**
     * 星速台项目id
     */
    private String projectxId;

    /**
     * 标题
     */
    private String title;

    /**
     * 消息信息
     * type=0时 普通文本
     * type=1时 json ["str1","str2"]，字符串分行展示
     */
    private String msg;

    /**
     * 消息类型 0-普通文本 1-markdown
     */
    private Integer type;

    /**
     * 被@的用户id ["userId","userId"]
     */
    private String atUserIds;

    /**
     * 被@前面的描述语
     */
    private String atMsg;

    @Builder
    public ProjectSendMsgDto(Long projectId, String projectxId, String title, String msg, Integer type, String atUserIds, String atMsg) {
        this.projectId = projectId;
        this.projectxId = projectxId;
        this.title = title;
        this.msg = msg;
        this.type = type;
        this.atUserIds = atUserIds;
        this.atMsg = atMsg;
    }
}
