package cn.com.duiba.devops.web.param.dingtalk;

import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;
import java.util.LinkedHashMap;

/**
 * 群消息参数
 *
 * @author ykb
 * @date 2022-02-28
 */
@Getter
@Setter
@NoArgsConstructor
public class GroupSendMsgDto implements Serializable {

    /**
     * 群会话id
     */
    private String openConversationId;

    /**
     * 标题
     */
    private String title;

    /**
     * 消息信息
     * type=0时 普通文本
     * type=1时 json ["str1","str2"]，字符串分行展示
     */
    private String msg;

    /**
     * 消息类型 0-普通文本 1-markdown 2-actionCard
     */
    private Integer type;

    /**
     * 被@的用户id ["userId","userId"]
     */
    private String atUserIds;

    /**
     * 被@前面的描述语
     */
    private String atMsg;

    /**
     * 卡片按钮展示样式 type == 3 actionCard 填写
     *  0 所有按钮配成一列
     *  1 每个按钮单独一列
     *  默认是1
     */
    private Integer actionCardType;

    /**
     * type == 3 actionCard 必填
     * map《"按钮名称", "按钮地址"》
     */
    private LinkedHashMap<String, String> map;

    @Builder
    public GroupSendMsgDto(String openConversationId, String title, String msg, Integer type, String atUserIds, String atMsg) {
        this.openConversationId = openConversationId;
        this.title = title;
        this.msg = msg;
        this.type = type;
        this.atUserIds = atUserIds;
        this.atMsg = atMsg;
    }
}
