package cn.com.duiba.devops.web.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.devops.web.model.amiya.AmiyaSimpleProjectRes;
import cn.com.duiba.devops.web.model.common.PageRes;
import cn.com.duiba.devops.web.param.amiya.ProjectSearchDto;

/**
 * 大雁项目远程服务
 *
 * @author fangxiaorun
 * @date 2022/10/24
 */
@AdvancedFeignClient
public interface RemoteAmiyaProjectService {

    /**
     * 通过keyWord检索大雁项目
     *
     * @param req 请求
     * @return {@link PageRes}<{@link AmiyaSimpleProjectRes}>
     */
    PageRes<AmiyaSimpleProjectRes> pageList(ProjectSearchDto req);
}

