package cn.com.duiba.devops.web.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.devops.web.param.amiya.ProjectSendMsgDto;

/**
 * 大雁业务remote接口
 *
 * @author ykb
 * @date 2022-02-28
 */
@AdvancedFeignClient
public interface RemoteAmiyaService {

    /**
     * 给指定项目发送钉钉群消息
     * 1. 默认项目已经绑定了钉钉群，可直接给该群发消息
     * 2. 若未绑定钉钉群，则抛异常
     *
     * @param projectSendMsgDto 群创建参数
     * @return {@link Boolean}
     */
    void projectSendMsg(ProjectSendMsgDto projectSendMsgDto);

    /**
     * 给已绑定星速台项目的大雁项目对应的钉钉群发送消息
     * 如果一个星速台项目id绑定多个群，则每个群都会发消息
     *
     * @param projectSendMsgDto 群创建参数
     */
    void projectxSendMsg(ProjectSendMsgDto projectSendMsgDto);



}
