package cn.com.duiba.devops.web.param.dingtalk;

import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 创建群参数
 *
 * @author ykb
 * @date 2022-02-28
 */
@Getter
@Setter
@NoArgsConstructor
public class GroupCreateDto implements Serializable {

    /**
     * 群名称
     */
    private String name;

    /**
     * 群主userId
     */
    private String owner;

    /**
     * 群用户ssoId集合，需包含群主
     */
    private List<Long> userList;

    @Builder
    public GroupCreateDto(String name, String owner, List<Long> userList) {
        this.name = name;
        this.owner = owner;
        this.userList = userList;
    }
}
