package cn.com.duiba.devops.web.param.dingtalk;

import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * 群消息参数
 *
 * @author ykb
 * @date 2022-02-28
 */
@Getter
@Setter
@NoArgsConstructor
public class GroupSendMsgDto implements Serializable {

    /**
     * 群会话id
     */
    private String openConversationId;

    /**
     * 标题
     */
    private String title;

    /**
     * 消息信息
     * type=0时 普通文本
     * type=1时 json ["str1","str2"]，字符串分行展示
     */
    private String msg;

    /**
     * 消息类型 0-普通文本 1-markdown
     */
    private Integer type;

    /**
     * 被@的用户id ["userId","userId"]
     */
    private String atUserIds;

    /**
     * 被@前面的描述语
     */
    private String atMsg;

    @Builder
    public GroupSendMsgDto(String openConversationId, String title, String msg, Integer type, String atUserIds, String atMsg) {
        this.openConversationId = openConversationId;
        this.title = title;
        this.msg = msg;
        this.type = type;
        this.atUserIds = atUserIds;
        this.atMsg = atMsg;
    }
}
