package cn.com.duiba.devops.web.param.dingtalk;

import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 群成员变更参数
 *
 * @author ykb
 * @date 2022-02-28
 */
@Getter
@Setter
@NoArgsConstructor
public class GroupUpdateDto implements Serializable {

    /**
     * 群会话id
     */
    private String openConversationId;

    /**
     * 待操作的群成员列表 ["userId1","userId2"]
     */
    private List<Long> userList;

    /**
     * 操作类型 0新增1删除
     */
    private Integer type;

    @Builder
    public GroupUpdateDto(String openConversationId, List<Long> userList, Integer type) {
        this.openConversationId = openConversationId;
        this.userList = userList;
        this.type = type;
    }
}
