package cn.com.duiba.dmp.client.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dmp.client.dto.CrowdConditionDto;
import cn.com.duiba.dmp.client.dto.CrowdDto;
import cn.com.duiba.dmp.client.dto.PartETagDto;
import cn.com.duiba.dmp.client.form.DMPCrowdForm;
import cn.com.duiba.dmp.client.form.DMPInfoForm;
import cn.com.duiba.dmp.client.form.MultipartUploadForm;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteDMPInfoService {
    List<CrowdDto> getDMPInfos(DMPInfoForm dmpForm);
    CrowdDto getSingleDMPInfo(DMPInfoForm dmpForm);

    /**
     * 根据人群包Id获取人群和条件数据
     */
    CrowdConditionDto getCrowdByCrowdId(Long crowdId);

    /**
     * 广告后台调用的人群包接口(人群包分页查询)
     * @param dmpForm crowdId，crowdName，validState，startTime，endTime，pageNum(必填)，pageSize(必填)，adminId(必填)
     * @return page 页码，size 当前页大小，total 总数，list:数据集合,详情见CrowdDto
     */
    Map<String, Object> advertCrowdList(DMPCrowdForm dmpForm);

    /**
     * 添加人群(文件上传)
     * @param form crowdName(人群包名称)，adminId(accountId)(广告主id)，
     *             dataType(数据类型：IMEIMD5 --> 1，IMEI--> 2 ,IDFA--> 3,IDFAMD5--> 4,IDFA 5,IDFA-MD5 6)，
     *             isAutoPush(是否自动推送)，deviceInfos(文件url列表)
     * @return 是否添加成功
     */
    Boolean advertAddCrowd(DMPCrowdForm form);

    /**
     * 文件追加
     * @param crowdId 人群包id
     * @param dataType dataType(数据类型：IMEIMD5 --> 1，IMEI--> 2 ,IDFA--> 3,IDFAMD5--> 4,IDFA 5,IDFA-MD5 6)
     * @param urls 文件url列表
     * @return 是否追加成功
     */
    Boolean urlAppend(Long crowdId, Integer dataType, List<String> urls);

    /**
     * 检查人群包名称是否重复
     * @param crowdId 人群包id
     * @param adminId 广告主id
     * @param crowdName 人群包名称
     * @return 是否重复
     */
    Boolean duplicateName(Long crowdId, Long adminId, String crowdName);

    /**
     * 批量推送
     * @param crowdIds 人群包id列表
     * @return 是否推送成功
     */
    Boolean pushBatch(List<Long> crowdIds);

    /**
     * 编辑人群包
     * @param crowdId 人群包id
     * @param crowdName 人群包名称
     * @return 是否编辑成功
     */
    Boolean editCrowd(Long crowdId, String crowdName);

    /**
     * 人群包详情
     * @param crowdId 人群包id
     * @return 人群包详情
     */
    CrowdDto crowdDetail(Long crowdId);

    /**
     * 初始化分片上传
     * @param request HttpServletRequest，参数列表直接透传过来即可
     * @param bucketName daily-duiba或者其他bucket
     * @param objectName 文件名称
     * @return uploadId
     */
    String initiateMultipartUpload(HttpServletRequest request, String bucketName, String objectName);

    /**
     * 上传分片文件
     * @param file 文件
     * @param bucketName daily-duiba或者其他bucket
     * @param objectName 文件名称
     * @param uploadId uploadId
     * @param partSize 当前分片大小
     * @param partNumber 当前分片number
     * @return 分片ETag详细信息
     * @throws Exception 异常
     */
    PartETagDto multipartUpload(MultipartFile file,
                                String bucketName, String objectName,
                                String uploadId, Integer partSize, Integer partNumber) throws Exception;

    /**
     * 整合分片
     * @param param 所需参数
     * @return oss文件url
     */
    String completeMultipartUpload(MultipartUploadForm param);
}
