/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddTag;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Geo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Imp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Site;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Template;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.User;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PddReqConverter {
    @Resource
    PddProperties dspPddProperties;

    public PddRequest reqConvert(AdxCommonBidRequest commonReq) {
        PddRequest pddRequest = new PddRequest();
        pddRequest.setAdx_id(this.dspPddProperties.getAdxId());
        pddRequest.setRequest_id(commonReq.getRequestId());
        pddRequest.setAt(Objects.isNull(commonReq.getAt()) ? 2 : commonReq.getAt());
        List<CommonImp> impList = commonReq.getImpList();
        List<Imp> imps = impList.stream().map(imp -> this.impConvert((CommonImp)imp, commonReq.getAdxType())).collect(Collectors.toList());
        pddRequest.setImp(imps);
        pddRequest.setSite(new Site());
        pddRequest.setApp(new App());
        pddRequest.setDevice(this.deviceConvert(commonReq.getDevice()));
        pddRequest.setUser(this.userConvert(commonReq.getUserInfo()));
        return pddRequest;
    }

    private User userConvert(CommonUserInfo userInfo) {
        User user = new User();
        if (Objects.isNull(userInfo)) {
            return user;
        }
        user.setId(userInfo.getId());
        user.setGender(userInfo.getGender());
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> user.setAge(String.valueOf(LocalDate.now().getYear() - yop)));
        return user;
    }

    private Device deviceConvert(CommonDevice commonDevice) {
        Device device = new Device();
        if (Objects.isNull(commonDevice)) {
            return device;
        }
        device.setUa(commonDevice.getUa());
        device.setIp(commonDevice.getIp());
        device.setDevicetype(commonDevice.getDeviceType());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        device.setOs(commonDevice.getOs());
        device.setCarrier(commonDevice.getCarrier());
        device.setImei(commonDevice.getImei());
        device.setImei_md5(commonDevice.getImeiMd5());
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfa_md5(commonDevice.getIdFaMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaid_md5(commonDevice.getOaIdMd5());
        device.setGeo(this.geoConvert(commonDevice.getGeo()));
        return device;
    }

    private Geo geoConvert(CommonGeo commonGeo) {
        Geo geo = new Geo();
        if (Objects.isNull(commonGeo)) {
            return geo;
        }
        Optional.ofNullable(commonGeo.getLat()).ifPresent(lat -> geo.setLatitude(Float.valueOf(lat.floatValue())));
        Optional.ofNullable(commonGeo.getLon()).ifPresent(leo -> geo.setLongitude(Float.valueOf(leo.floatValue())));
        return geo;
    }

    private App appConvert(CommonAppInfo appInfo) {
        App app = new App();
        if (Objects.isNull(appInfo)) {
            return app;
        }
        app.setId(appInfo.getId());
        app.setName(appInfo.getName());
        app.setBundle(appInfo.getBundle());
        app.setVersion(appInfo.getVersion());
        return app;
    }

    public Imp impConvert(CommonImp commonImp, Integer adxType) {
        Imp imp = new Imp();
        if (Objects.isNull(commonImp)) {
            return imp;
        }
        ArrayList<Template> templates = new ArrayList<Template>();
        List<CommonSizeInfo> filteringSize = commonImp.getFilteringSize();
        if (filteringSize != null && !filteringSize.isEmpty()) {
            filteringSize.forEach(fs -> {
                PddTag pddTag = PddTag.getByStyleId(adxType, fs.getType(), fs.getHeight(), fs.getWidth());
                if (Objects.nonNull((Object)pddTag)) {
                    imp.setTagid(pddTag.getTagId());
                    templates.add(new Template(pddTag.getTemplateId()));
                }
            });
            imp.setTemplates(templates);
        }
        imp.setId(commonImp.getId());
        imp.setBidfloor((int)Math.round(commonImp.getFloorPrice()));
        imp.setContent_type(Arrays.asList(1, 2));
        imp.setSupport_deeplink(commonImp.isOpenDeepLink());
        return imp;
    }

    public static void main(String[] args) {
        String commonBidReq = "{\"adxCode\":\"baiduAlliance\",\"adxType\":19,\"appInfo\":{\"bundle\":\"com.shyz.toutiao\",\"id\":\"11223311\",\"name\":\"11223311\",\"version\":\"\"},\"category\":\"2402\",\"device\":{\"carrier\":\"0\",\"connectionType\":\"4\",\"deviceType\":0,\"dpIdMd5\":\"fb9a624166d88cdd3f417c${cnt}f1c106\",\"geo\":{\"city\":\"\",\"country\":\"\u4e2d\u56fd\",\"region\":\"\",\"type\":0},\"hasDevice\":false,\"ip\":\"10.58.31.1\",\"make\":\"\",\"model\":\"\",\"os\":\"ANDROID\",\"ua\":\"Mozilla/5.0 (Linux; U; Androi d 2.3.6; zh-cn; GT-S5660 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1 MicroMessenger/4.5.255\"},\"externalDataPackageId\":\"100193\",\"filterCondition\":{\"adxFilterApplication\":\"11223311\",\"adxFilterPlatform\":\"03\"},\"impList\":[{\"adSlotType\":13,\"bidType\":1,\"externalAdBlockId\":\"8523\",\"filtering\":true,\"filteringSize\":[{\"height\":640,\"width\":960}],\"filteringTagIdSet\":[\"10011001110\",\"20022002220\",\"30033003330\",\"40044004440\",\"50055005550\",\"60066006660\",\"10001010001010100\",\"20002020002020200\",\"30003030003030300\"],\"floorPrice\":1.0,\"formatTypes\":[{\"height\":640,\"width\":960}],\"linkAgreement\":true,\"materialSpecInfo\":{\"height\":640,\"width\":960},\"openDeepLink\":false,\"tagId\":\"70077007770\",\"tagIndex\":1}],\"mediaChargeType\":2,\"mediaLaunchType\":1,\"requestId\":\"5b6da56c52168b02\",\"videoInfo\":{\"baiduVideo\":{\"adSlotType\":13,\"city\":\"\",\"contentLength\":0,\"district\":\"\",\"pageType\":0,\"province\":\"\",\"street\":\"\",\"title\":\"\",\"url\":\"https:// miniimg.eastday.com/detail_new/n200613083332625.html\",\"userTagIdList\":[100193]}},\"webTraffic\":false}";
        AdxCommonBidRequest adxCommonBidRequest = (AdxCommonBidRequest)JSONObject.parseObject((String)commonBidReq, AdxCommonBidRequest.class);
    }
}

