/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CloseableHttpClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseableHttpClientUtil.class);
    @Resource
    private CloseableHttpClient httpClient;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doGet(String url) {
        HttpGet request = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() != 200) return null;
            String strResult = EntityUtils.toString((HttpEntity)response.getEntity());
            request.releaseConnection();
            String string = strResult;
            return string;
        }
        catch (IOException e) {
            LOGGER.warn("CloseableHttpClientUtil.doGet error", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doPost(String url, Map<String, Object> params) {
        try {
            HttpPost request = new HttpPost();
            request.setURI(new URI(url));
            request.setHeader("Content-Type", "application/json; charset=utf-8");
            StringEntity s = new StringEntity(JSON.toJSONString(params));
            request.setEntity((HttpEntity)s);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
                int code = response.getStatusLine().getStatusCode();
                if (code != 200) return null;
                String res = EntityUtils.toString((HttpEntity)response.getEntity());
                request.releaseConnection();
                String string = res;
                return string;
            }
            catch (Exception ex) {
                LOGGER.warn("doPost error", (Throwable)ex);
                return null;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("doPost error", (Throwable)ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doPost(String url, JSONObject json) {
        HttpPost post = new HttpPost(url);
        try {
            StringEntity s = new StringEntity(json.toString());
            s.setContentEncoding("UTF-8");
            s.setContentType("application/x-www-form-urlencoded");
            post.setEntity((HttpEntity)s);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                if (response.getStatusLine().getStatusCode() != 200) return null;
                String res = EntityUtils.toString((HttpEntity)response.getEntity());
                post.releaseConnection();
                String string = res;
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.warn("CloseableHttpClientUtil.doPost error", (Throwable)e);
        }
        return null;
    }
}

