package cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.convert;


import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.bean.IqiyiBid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @author lizhiheng
 */
@Service
public class IqiyiReqConvert {
    @Resource
    private AppReplace appReplace;

    public IqiyiBid.BidRequest convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        IqiyiBid.BidRequest.Builder bidRequest = IqiyiBid.BidRequest.newBuilder();
        bidRequest.setId(adxCommonBidRequest.getRequestId());
        bidRequest.setTimestamp((int) System.currentTimeMillis());

        // Imp 转换
        IqiyiBid.BidRequest.Imp imp = impConvert(adxCommonBidRequest, dspInfo);
        bidRequest.addImp(imp);

        // 资源类型，这里假设根据 appInfo 存在与否判断
        bidRequest.setResourcetype(adxCommonBidRequest.getAppInfo() != null ? 1 : 0);

        // Site 和 App 转换
        if (bidRequest.getResourcetype() == 0) {
            // 假设这里没有站点信息，实际可根据需求完善
            bidRequest.setSite(IqiyiBid.BidRequest.Site.newBuilder().build());
        } else {
            IqiyiBid.BidRequest.App app = appConvert(adxCommonBidRequest.getAppInfo(), dspInfo);
            bidRequest.setApp(app);
        }

        // Device 转换
        IqiyiBid.BidRequest.Device device = deviceConvert(adxCommonBidRequest);
        bidRequest.setDevice(device);

        // User 转换
        IqiyiBid.BidRequest.User user = userConvert(adxCommonBidRequest);
        bidRequest.setUser(user);

        // 测试模式，假设默认为 false
        bidRequest.setTest(false);

        // 去重 ID 转换，假设这里没有去重需求，实际可根据需求完善
        bidRequest.addDeduplicatedIds(IqiyiBid.BidRequest.DeduplicatedId.newBuilder().build());
        return bidRequest.build();
    }

    private IqiyiBid.BidRequest.Imp impConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {

        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        IqiyiBid.BidRequest.Imp.Builder imp = IqiyiBid.BidRequest.Imp.newBuilder();
        imp.setAdzoneId(commonImp.getTagId());
//        imp.setMedia_adzone_id(commonImp.getMediaAdzoneId());
        imp.setAdType(IqiyiBid.BidRequest.Imp.AdType.forNumber(Integer.parseInt(dspInfo.getDspResId())));

        // Video 或 Native 转换
        if (commonImp.getFilteringSize().get(0).getType() == 3) {
            IqiyiBid.BidRequest.Imp.Video video = videoConvert(commonImp);
            imp.setVideo(video);
        } else {
            IqiyiBid.BidRequest.Imp.Native nativeAd = nativeConvert(commonImp);
//            imp.setNativeAd(nativeAd);
        }

        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        imp.setBidfloor((int) floorPrice);

        return imp.build();
    }

    private IqiyiBid.BidRequest.Imp.Video videoConvert(CommonImp commonImp) {
        IqiyiBid.BidRequest.Imp.Video.Builder video = IqiyiBid.BidRequest.Imp.Video.newBuilder();
        // 假设广告展现样式为线性贴片
        video.setLinearity(IqiyiBid.BidRequest.Imp.Video.VideoLinearity.LINEAR);
//        List<Integer> acceptedCreativeTypes = new ArrayList<>();
//        acceptedCreativeTypes.add(2); // 视频
        video.setAcceptedCreativeTypes(2);

        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        video.setW(commonSizeInfo.getWidth());
        video.setH(commonSizeInfo.getHeight());
        video.setMinduration(commonSizeInfo.getMinduration());
        video.setMaxduration(commonSizeInfo.getMaxduration());
        // 假设为前贴
        video.setStartdelay(0);
        video.setMaxadscount(1);
        // 假设视频格式为 MP4
        video.setFormat(IqiyiBid.BidRequest.Imp.VideoFormat.VIDEO_MP4);

        return video.build();
    }

    private IqiyiBid.BidRequest.Imp.Native nativeConvert(CommonImp commonImp) {
        IqiyiBid.BidRequest.Imp.Native.Builder nativeAd = IqiyiBid.BidRequest.Imp.Native.newBuilder();
        // 假设最大标题长度为 100
        nativeAd.setTitleLen(100);

        List<IqiyiBid.BidRequest.Imp.Native.Image> imgs = new ArrayList<>();
        IqiyiBid.BidRequest.Imp.Native.Image.Builder image = IqiyiBid.BidRequest.Imp.Native.Image.newBuilder();
        // 假设图片类型为 Main
        image.setType(IqiyiBid.BidRequest.Imp.Native.Image.ImageAssetType.MAIN);
        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        image.setW(commonSizeInfo.getWidth());
        image.setH(commonSizeInfo.getHeight());

        nativeAd.addImgs(image);

//        nativeAd.setNativeVideo(null); // 假设没有视频元素
        nativeAd.setMaxadscount(1);

        return nativeAd.build();
    }

    private IqiyiBid.BidRequest.App appConvert(CommonAppInfo appInfo, DspInfo dspInfo) {
        IqiyiBid.BidRequest.App.Builder app = IqiyiBid.BidRequest.App.newBuilder();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setBundle(replaceApp.getBundle());
        } else {
            app.setBundle(appInfo.getBundle());
        }
        app.setName(StringUtils.isNotEmpty(appInfo.getName()) ? appInfo.getName() : "");
//        app.setDomain(appInfo.getDomain());
//        app.setStoreurl(appInfo.getStoreUrl());
//        app.setCat(appInfo.getCat());
        app.setVer(appInfo.getVersion());
//        app.setPaid(appInfo.isPaid());
        app.setKeywords(StringUtils.isNotEmpty(appInfo.getKeywords()) ? appInfo.getKeywords() : "");
//        app.setDeeplinkstate(appInfo.getDeeplinkState());

        return app.build();
    }

    private IqiyiBid.BidRequest.Device deviceConvert(AdxCommonBidRequest adxCommonBidRequest) {
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        IqiyiBid.BidRequest.Device.Builder device = IqiyiBid.BidRequest.Device.newBuilder();
        String ip = commonDevice.getIp();
        if (ip.contains(":")) {
            device.setIp(ip);
        } else {
            device.setIp(ip);
        }
        device.setUa(commonDevice.getUa());
        String carrier = commonDevice.getCarrier();
        if ("1".equals(carrier)) {
            device.setCarrier(1);
        } else if ("2".equals(carrier)) {
            device.setCarrier(2);
        } else if ("3".equals(carrier)) {
            device.setCarrier(3);
        } else {
            // 这里没有unknown的枚举值，就这么传吧
            device.setCarrier(4);
        }
        Integer connectionType = commonDevice.getTuiaConnectionType();
        if (connectionType == 2) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.WIFI);
        } else if (connectionType == 4) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_2G);
        } else if (connectionType == 5) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_3G);
        } else if (connectionType == 6) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_4G);
        } else if (connectionType == 7) {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_5G);
        } else {
            device.setConnectiontype(IqiyiBid.BidRequest.Device.ConnectionType.CELL_UNKNOWN);
        }
        device.setDevicetype(IqiyiBid.BidRequest.Device.DeviceType.UNKNOWN_DEVICE);
//        if ("1".equals(commonDevice.getOs())) {
//            device.setOs(OS.IOS.getCode());
//        } else if ("0".equals(commonDevice.getOs())) {
//            device.setOs(OS.ANDROID.getCode());
//        } else {
//            device.setOs(OS.UNKNOWN_OS.getCode());
//        }
        device.setOsv(commonDevice.getOsVersion());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());


        IqiyiBid.BidRequest.Geo geo = geoConvert(commonDevice.getGeo());
        device.setGeo(geo);

        return device.build();
    }

    private IqiyiBid.BidRequest.Geo geoConvert(CommonGeo commonGeo) {
        IqiyiBid.BidRequest.Geo.Builder geo = IqiyiBid.BidRequest.Geo.newBuilder();
        if (commonGeo != null) {
            if (commonGeo.getLat() != null && commonGeo.getLon() != null) {
                geo.setLat(commonGeo.getLat().floatValue());
                geo.setLon(commonGeo.getLon().floatValue());
                // 假设位置来源为 IP 地址
                geo.setType(IqiyiBid.BidRequest.Geo.LocationType.IP);
            }
//            geo.setCountry(commonGeo.getCountry());
//            geo.setProv(commonGeo.getProv());
//            geo.setCity(commonGeo.getCity());
//            geo.setDistrict(commonGeo.getDistrict());
        }
        return geo.build();
    }

    private IqiyiBid.BidRequest.User userConvert(AdxCommonBidRequest adxCommonBidRequest) {
        IqiyiBid.BidRequest.User.Builder user = IqiyiBid.BidRequest.User.newBuilder();
        CommonUserInfo userInfo = adxCommonBidRequest.getUserInfo();
        if (StringUtils.isNotEmpty(userInfo.getId()) && Objects.nonNull(userInfo.getId())) {
            user.setId(user.getId());
        }
        if (StringUtils.isNotEmpty(userInfo.getGender()) && Objects.nonNull(userInfo.getGender())) {
            user.setGender(userInfo.getGender());
        }
//        user.setTag_id();
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> user.setAge(Integer.parseInt(String.valueOf(LocalDate.now().getYear() - yop))));
        if (StringUtils.isNotEmpty(userInfo.getKeywords()) && Objects.nonNull(userInfo.getKeywords())) {
            user.setKeywords(userInfo.getKeywords());
        }
        return user.build();
    }
}
