package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;


/**
 * 门面接口
 *
 * @author lizhiheng
 */
public abstract class DspFacadeInterface {
    /**
     * 调用DSP接口的门面方法
     * 需要传入公共请求参数和外部dsp接口
     * doInvoke接口做了
     * 1。异步请求所需的外部dsp调用
     * 2。进行比价
     * 3。返回
     *
     * @param adxCommonBidRequest
     * @param dspIds
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     * @throws TimeoutException
     */
    abstract AdxCommonBidResponse doInvoke(AdxCommonBidRequest adxCommonBidRequest, List<Integer> dspIds) throws ExecutionException, InterruptedException, TimeoutException;

    /**
     * 比价方法，
     *
     * @param responseList
     * @return
     */
    protected AdxCommonBidResponse comparePrice(List<AdxCommonBidResponse> responseList) {
        if (Objects.isNull(responseList) || responseList.isEmpty()) {
            return null;
        }
        AtomicReference<AdxCommonBidResponse> adxCommonBidResponse = new AtomicReference<>();
        responseList.stream()
                .filter(Objects::nonNull)
                // FIXME: 2022/7/8 这里可能会有NPE问题，稍后测试的时候修复
                .max((res1, res2) -> (int) (res1.getCommonSeatBidList().get(0).getPrice() - res2.getCommonSeatBidList().get(0).getPrice()))
                .ifPresent(adxCommonBidResponse::set);
        return adxCommonBidResponse.get();
    }

    /**
     * 价格加密方法
     *
     * @param price
     * @param dspId
     * @return
     */
    public abstract String priceEncryption(BigDecimal price, Integer dspId);
}
