/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.tuia.dsp.engine.api.config.DspRateLimiter;
import cn.com.duiba.tuia.dsp.engine.api.config.RateLimiterProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.DspFacadeInterface;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DspFacade
extends DspFacadeInterface
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Resource
    ExecutorService executorService;
    @Resource
    RateLimiterProperties rateLimiterProperties;
    @Resource
    DspRateLimiter rateLimiter;
    private static final Logger LOGGER = LoggerFactory.getLogger(DspFacade.class);

    @Override
    public AdxCommonBidResponse doInvoke(AdxCommonBidRequest adxCommonBidRequest, List<Integer> dspIds) throws DspException {
        List<AdxCommonBidResponse> adxCommonBidResponses = this.generateFutures(adxCommonBidRequest, dspIds);
        return this.comparePrice(adxCommonBidResponses);
    }

    @Override
    public String priceEncryption(BigDecimal price, Integer dspId) {
        AbstractDspCaller caller = (AbstractDspCaller)this.applicationContext.getBean(DspEnum.getByDspId(dspId).getClazz());
        return caller.priceEncryption(price);
    }

    public List<AdxCommonBidResponse> generateFutures(AdxCommonBidRequest adxCommonBidRequest, List<Integer> dspIds) {
        if (this.rateLimiter.getRateLimiter().tryAcquire((long)this.rateLimiterProperties.getRequireTimeout().intValue(), TimeUnit.MICROSECONDS)) {
            ArrayList futures = new ArrayList();
            dspIds.forEach(idea -> {
                AbstractDspCaller dspCaller = (AbstractDspCaller)this.applicationContext.getBean(DspEnum.getByDspId(idea).getClazz());
                CompletableFuture<AdxCommonBidResponse> adxCommonBidResponseCompletableFuture = CompletableFuture.supplyAsync(() -> dspCaller.doBid(adxCommonBidRequest), this.executorService);
                futures.add(adxCommonBidResponseCompletableFuture);
            });
            try {
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(this.rateLimiterProperties.getFutureTimeOut().intValue(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                Cat.logMetricForCount((String)"DSP\u5e76\u884c\u8bf7\u6c42\u603b\u7ebf\u6267\u884c\u8d85\u65f6");
            }
            catch (Exception e) {
                Cat.logMetricForCount((String)"DSP\u5e76\u884c\u8bf7\u6c42\u603b\u7ebf\u6267\u884c\u5931\u8d25");
                LOGGER.warn("DSP\u5e76\u884c\u8bf7\u6c42\u603b\u7ebf\u6267\u884c\u5931\u8d25", (Throwable)e);
            }
            return futures.stream().map(future -> {
                try {
                    return (AdxCommonBidResponse)future.get(this.rateLimiterProperties.getFutureTimeOut().intValue(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    Cat.logMetricForCount((String)"DSP\u8bf7\u6c42\u5355\u4e2a\u4efb\u52a1\u8d85\u65f6");
                    LOGGER.warn("DSP\u8bf7\u6c42\u5355\u4e2a\u4efb\u52a1\u8d85\u65f6");
                }
                catch (Exception e) {
                    Cat.logMetricForCount((String)"DSP\u8bf7\u6c42\u5355\u4e2aDSP\u5931\u8d25");
                    LOGGER.warn("DSP\u8bf7\u6c42\u5355\u4e2aDSP\u5931\u8d25", (Throwable)e);
                }
                return null;
            }).collect(Collectors.toList());
        }
        Cat.logMetricForCount((String)"DSP\u9650\u6d41");
        LOGGER.info("DSP\u8bf7\u6c42\u9650\u6d41\uff0c\u8d85\u8fc7\u9608\u503c\uff0c{}/s", (Object)this.rateLimiterProperties.getTokenPerSec());
        return null;
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

